/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.openforis.collect.designer.form.SurveyObjectFormObject;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.VersionableSurveyObject;

public class VersionableItemFormObject<T extends VersionableSurveyObject>
extends SurveyObjectFormObject<T> {
    private int sinceVersionId;
    private int deprecatedVersionId;

    @Override
    public void loadFrom(T source, String languageCode) {
        super.loadFrom(source, languageCode);
        ModelVersion sinceVersion = source.getSinceVersion();
        this.sinceVersionId = sinceVersion != null ? sinceVersion.getId() : -1;
        ModelVersion deprecatedVersion = source.getDeprecatedVersion();
        this.deprecatedVersionId = deprecatedVersion != null ? deprecatedVersion.getId() : -1;
    }

    @Override
    public void saveTo(T dest, String languageCode) {
        Survey survey = dest.getSurvey();
        ModelVersion sinceVersion = null;
        if (this.sinceVersionId > 0) {
            sinceVersion = survey.getVersionById(this.sinceVersionId);
        }
        dest.setSinceVersion(sinceVersion);
        ModelVersion deprecatedVersion = null;
        if (this.deprecatedVersionId > 0) {
            deprecatedVersion = survey.getVersionById(this.deprecatedVersionId);
        }
        dest.setDeprecatedVersion(deprecatedVersion);
    }

    @Override
    protected void reset() {
        this.sinceVersionId = -1;
        this.deprecatedVersionId = -1;
    }

    public int getSinceVersionId() {
        return this.sinceVersionId;
    }

    public void setSinceVersionId(int sinceVersionId) {
        this.sinceVersionId = sinceVersionId;
    }

    public int getDeprecatedVersionId() {
        return this.deprecatedVersionId;
    }

    public void setDeprecatedVersionId(int deprecatedVersionId) {
        this.deprecatedVersionId = deprecatedVersionId;
    }
}

