/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import java.util.Date;
import org.openforis.collect.designer.form.validator.SurveyObjectFormValidator;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Dates;
import org.openforis.idm.metamodel.ModelVersion;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class ModelVersionFormValidator
extends SurveyObjectFormValidator<ModelVersion> {
    protected static final String NAME_FIELD = "name";
    protected static final String DATE_FIELD = "date";
    private static final String ITEM_DATE_ALREADY_DEFINED_MESSAGE_KEY = "survey.versioning.validation.error.duplicate_date";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        this.validateDate(ctx);
        this.validateName(ctx);
    }

    private boolean validateDate(ValidationContext ctx) {
        if (this.validateRequired(ctx, DATE_FIELD)) {
            return this.validateDateUniqueness(ctx);
        }
        return false;
    }

    private boolean validateDateUniqueness(ValidationContext ctx) {
        SurveyObjectBaseVM viewModel = (SurveyObjectBaseVM)this.getVM(ctx);
        ModelVersion editedItem = (ModelVersion)viewModel.getEditedItem();
        CollectSurvey survey = viewModel.getSurvey();
        Date date = (Date)this.getValue(ctx, DATE_FIELD);
        for (ModelVersion modelVersion : survey.getVersions()) {
            if (modelVersion.getId() == editedItem.getId() || Dates.compareDateOnly((Date)modelVersion.getDate(), (Date)date) != 0) continue;
            String message = Labels.getLabel((String)ITEM_DATE_ALREADY_DEFINED_MESSAGE_KEY);
            this.addInvalidMessage(ctx, DATE_FIELD, message);
            return false;
        }
        return true;
    }

    protected boolean validateName(ValidationContext ctx) {
        if (this.validateRequired(ctx, NAME_FIELD)) {
            return this.validateNameUniqueness(ctx);
        }
        return false;
    }

    protected boolean validateNameUniqueness(ValidationContext ctx) {
        String name;
        SurveyObjectBaseVM viewModel = (SurveyObjectBaseVM)this.getVM(ctx);
        ModelVersion editedItem = (ModelVersion)viewModel.getEditedItem();
        CollectSurvey survey = viewModel.getSurvey();
        ModelVersion existingItem = survey.getVersion(name = (String)this.getValue(ctx, NAME_FIELD));
        if (existingItem != null && existingItem.getId() != editedItem.getId()) {
            String message = Labels.getLabel((String)"global.item.validation.name_already_defined");
            this.addInvalidMessage(ctx, NAME_FIELD, message);
            return false;
        }
        return true;
    }
}

