/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.Collection;
import java.util.List;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseSurveyFileImportVM;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.JobStatusPopUpVM;
import org.openforis.collect.designer.viewmodel.SamplingPointDataVM;
import org.openforis.collect.designer.viewmodel.SurveyEditVM;
import org.openforis.collect.designer.viewmodel.referencedata.ReferenceDataImportErrorsPopUpVM;
import org.openforis.collect.io.metadata.samplingdesign.SamplingPointDataImportJob;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.concurrency.Job;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Window;

public class SamplingPointDataImportPopUpVM
extends BaseSurveyFileImportVM {
    private static final String EXAMPLE_FILENAME = "sampling-point-data-example.xlsx";
    private Window jobStatusPopUp;

    public SamplingPointDataImportPopUpVM() {
        super(new String[]{"csv", "xlsx"}, EXAMPLE_FILENAME);
    }

    public static Window openPopUp() {
        return SamplingPointDataImportPopUpVM.openPopUp(Resources.Component.SAMPLING_POINT_DATA_IMPORT_POPUP.getLocation(), true);
    }

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
    }

    @Command
    public void close(@ContextParam(value=ContextType.TRIGGER_EVENT) Event event) {
        if (event != null) {
            event.stopPropagation();
        }
        SamplingPointDataVM.dispatchSamplingPointDataImportPopUpCloseCommand();
    }

    public String getAvailableSrsIds() {
        List spatialReferenceSystems = this.getSurvey().getSpatialReferenceSystems();
        return String.join((CharSequence)", ", CollectionUtils.project((Collection)spatialReferenceSystems, (String)"id"));
    }

    @Command
    public void importSamplingPointData() {
        MessageUtil.showConfirm(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                SamplingPointDataImportJob job = (SamplingPointDataImportJob)SamplingPointDataImportPopUpVM.this.jobManager.createJob(SamplingPointDataImportJob.class);
                job.setSurvey(SamplingPointDataImportPopUpVM.this.getSurvey());
                job.setFile(SamplingPointDataImportPopUpVM.this.uploadedFile);
                SamplingPointDataImportPopUpVM.this.jobManager.start((Job)job);
                SamplingPointDataImportPopUpVM.this.monitorImportJob(job);
            }
        }, "survey.sampling_point_data.import_data.confirm_import");
    }

    private void monitorImportJob(SamplingPointDataImportJob job) {
        final String messagePrefix = "survey.sampling_point_data.import_data.";
        this.jobStatusPopUp = JobStatusPopUpVM.openPopUp(messagePrefix + "title", job, true, new JobStatusPopUpVM.JobEndHandler<SamplingPointDataImportJob>(){

            @Override
            public void onJobEnd(SamplingPointDataImportJob job) {
                BaseVM.closePopUp(SamplingPointDataImportPopUpVM.this.jobStatusPopUp);
                switch (job.getStatus()) {
                    case COMPLETED: {
                        MessageUtil.showInfo(messagePrefix + "completed", new Object[0]);
                        SurveyEditVM.dispatchSurveySaveCommand();
                        SamplingPointDataVM.notifySamplingPointDataUpdated();
                        SamplingPointDataImportPopUpVM.this.close(null);
                        break;
                    }
                    case FAILED: {
                        String title = Labels.getLabel((String)(messagePrefix + "error_popup.title"), (Object[])new String[]{SamplingPointDataImportPopUpVM.this.getUploadedFileName()});
                        ReferenceDataImportErrorsPopUpVM.showPopUp(job.getErrors(), title);
                        break;
                    }
                }
            }
        });
    }
}

