/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.HashMap;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseSurveyFileImportVM;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.JobStatusPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyEditVM;
import org.openforis.collect.designer.viewmodel.TaxonomiesVM;
import org.openforis.collect.designer.viewmodel.referencedata.ReferenceDataImportErrorsPopUpVM;
import org.openforis.collect.io.metadata.species.SpeciesImportJob;
import org.openforis.concurrency.Job;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Window;

public class TaxonomyImportPopUpVM
extends BaseSurveyFileImportVM {
    private static final String EXAMPLE_FILENAME = "species-list-example.xlsx";
    private Window jobStatusPopUp;
    private int taxonomyId;

    public TaxonomyImportPopUpVM() {
        super(new String[]{"csv", "xlsx"}, EXAMPLE_FILENAME);
    }

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="taxonomyId") int taxonomyId) {
        super.init();
        this.taxonomyId = taxonomyId;
    }

    public static Window openPopUp(int taxonomyId) {
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("taxonomyId", taxonomyId);
        return TaxonomyImportPopUpVM.openPopUp(Resources.Component.TAXONOMY_IMPORT_POPUP.getLocation(), true, args);
    }

    @Command
    public void close(@ContextParam(value=ContextType.TRIGGER_EVENT) Event event) {
        if (event != null) {
            event.stopPropagation();
        }
        TaxonomiesVM.dispatchCloseTaxonomyImportPopUpCommand();
    }

    @Command
    public void importData() {
        MessageUtil.showConfirm(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                SpeciesImportJob job = (SpeciesImportJob)TaxonomyImportPopUpVM.this.jobManager.createJob(SpeciesImportJob.class);
                job.setSurvey(TaxonomyImportPopUpVM.this.getSurvey());
                job.setFile(TaxonomyImportPopUpVM.this.uploadedFile);
                job.setTaxonomyId(TaxonomyImportPopUpVM.this.taxonomyId);
                TaxonomyImportPopUpVM.this.jobManager.start((Job)job);
                TaxonomyImportPopUpVM.this.monitorImportJob(job);
            }
        }, "survey.taxonomy.import_data.confirm_import");
    }

    private void monitorImportJob(SpeciesImportJob job) {
        final String messagePrefix = "survey.taxonomy.import_data.";
        this.jobStatusPopUp = JobStatusPopUpVM.openPopUp(messagePrefix + "title", job, true, new JobStatusPopUpVM.JobEndHandler<SpeciesImportJob>(){

            @Override
            public void onJobEnd(SpeciesImportJob job) {
                BaseVM.closePopUp(TaxonomyImportPopUpVM.this.jobStatusPopUp);
                switch (job.getStatus()) {
                    case COMPLETED: {
                        MessageUtil.showInfo(messagePrefix + "completed", new Object[0]);
                        SurveyEditVM.dispatchSurveySaveCommand();
                        TaxonomiesVM.dispatchTaxonomyUpdatedCommand(TaxonomyImportPopUpVM.this.taxonomyId);
                        TaxonomyImportPopUpVM.this.close(null);
                        break;
                    }
                    case FAILED: {
                        String title = Labels.getLabel((String)(messagePrefix + "error_popup.title"), (Object[])new String[]{TaxonomyImportPopUpVM.this.getUploadedFileName()});
                        ReferenceDataImportErrorsPopUpVM.showPopUp(job.getErrors(), title);
                        break;
                    }
                }
            }
        });
    }
}

