/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.listener;

import io.sentry.Sentry;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.ConnectionProvider;
import org.jooq.impl.DataSourceConnectionProvider;
import org.openforis.collect.Collect;
import org.openforis.collect.config.CollectConfiguration;
import org.openforis.collect.persistence.DbInitializer;
import org.openforis.collect.persistence.DbUtils;

public class ApplicationInitializerServletContextListener
implements ServletContextListener {
    private static final Logger LOG = LogManager.getLogger(ApplicationInitializerServletContextListener.class);
    private static final String SENTRY_DSN = "https://d3693c474ffb41f2b5e6265dc3411705@sentry.io/1246866?release=" + Collect.VERSION;
    private static final String DEV_MODE_INIT_PARAMETER_NAME = "devMode";

    public void contextInitialized(ServletContextEvent sce) {
        LOG.info("========Open Foris Collect - Starting initialization ==========");
        this.initSentry();
        this.initDB();
        CollectConfiguration.setDevelopmentMode(this.determineIsDevelopmentMode(sce));
        this.configureOfUsersModule(sce);
        LOG.info("========Open Foris Collect - Initialized ======================");
    }

    private void initSentry() {
        Sentry.init(options -> options.setDsn(SENTRY_DSN));
    }

    private boolean determineIsDevelopmentMode(ServletContextEvent sce) {
        return Boolean.parseBoolean(sce.getServletContext().getInitParameter(DEV_MODE_INIT_PARAMETER_NAME));
    }

    private void configureOfUsersModule(ServletContextEvent sce) {
        LOG.info("======== Starting OF-Users module configuration ========");
        ServletContext sc = sce.getServletContext();
        String usersServiceProtocol = (String)ObjectUtils.defaultIfNull((Object)sc.getInitParameter("of_users.service.protocol"), (Object)"http");
        String usersServiceHost = (String)ObjectUtils.defaultIfNull((Object)sc.getInitParameter("of_users.service.host"), (Object)this.determineHostName());
        int usersServicePort = Integer.parseInt((String)ObjectUtils.defaultIfNull((Object)sc.getInitParameter("of_users.service.port"), (Object)this.determineLocalPort()));
        CollectConfiguration.initUsersServiceConfiguration(new CollectConfiguration.ServiceConfiguration(usersServiceProtocol, usersServiceHost, usersServicePort));
        LOG.info("======== End of OF-Users module configuration ========");
    }

    private void initDB() {
        LOG.info("========Open Foris Collect - Starting DB initialization ========");
        DataSourceConnectionProvider connectionProvider = new DataSourceConnectionProvider(DbUtils.getDataSource());
        new DbInitializer((ConnectionProvider)connectionProvider).start();
        LOG.info("========Open Foris Collect - DB Initialized ====================");
    }

    private String determineHostName() {
        if (CollectConfiguration.isDevelopmentMode()) {
            return "127.0.0.1";
        }
        try {
            String hostName = InetAddress.getLocalHost().getHostAddress();
            return hostName;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private String determineLocalPort() {
        try {
            return this.determineConnectorProperty("port");
        }
        catch (Exception e) {
            return "8380";
        }
    }

    private String determineConnectorProperty(String property) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> objectNames = mBeanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            String result = objectNames.iterator().next().getKeyProperty(property);
            return result;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

