/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.validator;

import java.util.List;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.collect.web.controller.UserGroupController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class UserGroupValidator
extends SimpleValidator<UserGroupController.UserGroupForm> {
    private static final String NAME_FIELD = "name";
    private static final String LABEL_FIELD = "label";
    @Autowired
    private UserGroupManager userGroupManager;

    @Override
    public void validateForm(UserGroupController.UserGroupForm target, Errors errors) {
        if (this.validateRequiredField(errors, NAME_FIELD) && this.validateInternalName(errors, NAME_FIELD)) {
            this.validateUniqueness(target, errors);
        }
        this.validateRequiredField(errors, LABEL_FIELD);
        this.validateUsers(target, errors);
    }

    private boolean validateUsers(UserGroupController.UserGroupForm target, Errors errors) {
        if (this.hasOwner(target)) {
            return true;
        }
        errors.reject("usergroup.validation.missing_owner");
        return false;
    }

    private boolean hasOwner(UserGroupController.UserGroupForm target) {
        List<UserGroupController.UserInGroupForm> users = target.getUsers();
        if (users != null && !users.isEmpty()) {
            for (UserGroupController.UserInGroupForm user : users) {
                if (user.getRole() != UserInGroup.UserGroupRole.OWNER) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateUniqueness(UserGroupController.UserGroupForm target, Errors errors) {
        UserGroup duplicateGroup = this.userGroupManager.findByName(target.getName());
        if (!(duplicateGroup == null || target.getId() != null && duplicateGroup.getId().equals(target.getId()))) {
            this.rejectDuplicateValue(errors, NAME_FIELD, new Object[0]);
            return false;
        }
        return true;
    }
}

