/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.controller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryExecutorJob;
import org.openforis.collect.datacleansing.DataQueryResultItem;
import org.openforis.collect.datacleansing.form.DataQueryForm;
import org.openforis.collect.datacleansing.form.DataQueryResultItemForm;
import org.openforis.collect.datacleansing.form.validation.DataQueryValidator;
import org.openforis.collect.datacleansing.json.JSONValueFormatter;
import org.openforis.collect.datacleansing.manager.DataQueryManager;
import org.openforis.collect.io.data.CSVDataExportJob;
import org.openforis.collect.io.data.DescendantNodeFilter;
import org.openforis.collect.io.data.NodeFilter;
import org.openforis.collect.io.data.csv.CSVDataExportParameters;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.NodeProcessor;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.web.controller.AbstractPersistedObjectEditFormController;
import org.openforis.collect.web.controller.AbstractSurveyObjectEditFormController;
import org.openforis.collect.web.controller.CollectJobController;
import org.openforis.commons.web.Forms;
import org.openforis.commons.web.HttpResponses;
import org.openforis.commons.web.Response;
import org.openforis.concurrency.Job;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="session")
@RequestMapping(value={"api/datacleansing/dataqueries"})
public class DataQueryController
extends AbstractSurveyObjectEditFormController<Integer, DataQuery, DataQueryForm, DataQueryManager> {
    private static final int TEST_MAX_RECORDS = 100;
    @Autowired
    protected SessionManager sessionManager;
    @Autowired
    private CollectJobManager collectJobManager;
    @Autowired
    private DataQueryValidator validator;
    private DataQueryExecutorJob testJob;
    private CSVDataExportJob exportJob;

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.validator);
    }

    @Override
    protected DataQuery createItemInstance(CollectSurvey survey) {
        return new DataQuery(survey);
    }

    @Override
    protected DataQueryForm createFormInstance(DataQuery item) {
        return new DataQueryForm(item);
    }

    @RequestMapping(value={"start-export.json"}, method={RequestMethod.POST})
    @ResponseBody
    public Response startExport(@Validated DataQueryForm form, @RequestParam CollectRecord.Step recordStep) throws Exception {
        CollectSurvey survey = this.sessionManager.getActiveSurvey();
        DataQuery query = new DataQuery(survey);
        form.copyTo((Object)query, new String[0]);
        this.exportJob = (CSVDataExportJob)this.collectJobManager.createJob(CSVDataExportJob.class);
        this.exportJob.setOutputFile(File.createTempFile("data-query-export", ".csv"));
        CSVDataExportParameters parameters = new CSVDataExportParameters();
        RecordFilter recordFilter = new RecordFilter(survey);
        recordFilter.setStepGreaterOrEqual(recordStep);
        parameters.setRecordFilter(recordFilter);
        parameters.setEntityId(Integer.valueOf(query.getEntityDefinitionId()));
        parameters.setAlwaysGenerateZipFile(false);
        parameters.setNodeFilter((NodeFilter)new DescendantNodeFilter(query.getAttributeDefinition(), query.getConditions()));
        this.exportJob.setParameters(parameters);
        this.collectJobManager.start((Job)this.exportJob);
        Response response = new Response();
        return response;
    }

    @RequestMapping(value={"start-test.json"}, method={RequestMethod.POST})
    @ResponseBody
    public Response startTest(@Validated DataQueryForm form, @RequestParam CollectRecord.Step recordStep, BindingResult result) {
        List errors = result.getAllErrors();
        if (errors.isEmpty()) {
            CollectSurvey survey = this.sessionManager.getActiveSurvey();
            DataQuery query = new DataQuery(survey);
            form.copyTo((Object)query, new String[0]);
            this.testJob = (DataQueryExecutorJob)this.collectJobManager.createJob(DataQueryExecutorJob.class);
            this.testJob.setInput(new DataQueryExecutorJob.DataQueryExecutorJobInput(query, recordStep, new MemoryStoreDataQueryResultItemProcessor(query), 100));
            this.collectJobManager.start((Job)this.testJob);
            return new Response();
        }
        return new AbstractPersistedObjectEditFormController.SimpleFormUpdateResponse(this, errors);
    }

    @RequestMapping(value={"result.csv"}, method={RequestMethod.GET})
    public void downloadResult(HttpServletResponse response) throws FileNotFoundException, IOException {
        File file = this.exportJob.getOutputFile();
        Controllers.writeFileToResponse(response, file, "collect-query.csv", "text/csv");
    }

    @RequestMapping(value={"test-result.json"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DataQueryResultItemForm> downloadTestResult(HttpServletResponse response) throws FileNotFoundException, IOException {
        if (this.testJob == null) {
            return Collections.emptyList();
        }
        List<DataQueryResultItem> items = ((MemoryStoreDataQueryResultItemProcessor)this.testJob.getInput().getNodeProcessor()).getItems();
        List result = Forms.toForms(items, DataQueryResultItemForm.class);
        return result;
    }

    @RequestMapping(value={"export-job.json"}, method={RequestMethod.GET})
    @ResponseBody
    public CollectJobController.JobView getExportJob(HttpServletResponse response) {
        return this.createJobView(response, (Job)this.exportJob);
    }

    @RequestMapping(value={"export-job.json"}, method={RequestMethod.DELETE})
    @ResponseBody
    public CollectJobController.JobView cancelExportJob(HttpServletResponse response) {
        if (this.exportJob != null) {
            this.exportJob.abort();
        }
        return this.createJobView(response, (Job)this.exportJob);
    }

    @RequestMapping(value={"test-job.json"}, method={RequestMethod.GET})
    @ResponseBody
    public CollectJobController.JobView getTestJob(HttpServletResponse response) {
        return this.createJobView(response, (Job)this.testJob);
    }

    @RequestMapping(value={"test-job.json"}, method={RequestMethod.DELETE})
    @ResponseBody
    public CollectJobController.JobView cancelTestJob(HttpServletResponse response) {
        if (this.testJob != null) {
            this.testJob.abort();
        }
        return this.createJobView(response, (Job)this.testJob);
    }

    private CollectJobController.JobView createJobView(HttpServletResponse response, Job job) {
        if (job == null) {
            HttpResponses.setNoContentStatus((HttpServletResponse)response);
            return null;
        }
        return new CollectJobController.JobView(job);
    }

    private static class MemoryStoreDataQueryResultItemProcessor
    extends AttributeQueryResultItemProcessor {
        private List<DataQueryResultItem> items = new ArrayList<DataQueryResultItem>();

        public MemoryStoreDataQueryResultItemProcessor(DataQuery query) {
            super(query);
        }

        @Override
        public void process(DataQueryResultItem item) {
            this.items.add(item);
        }

        public List<DataQueryResultItem> getItems() {
            return this.items;
        }
    }

    static abstract class AttributeQueryResultItemProcessor
    implements NodeProcessor {
        protected DataQuery query;

        public AttributeQueryResultItemProcessor(DataQuery query) {
            this.query = query;
        }

        @Override
        public void process(Node<?> node) {
            CollectRecord record = (CollectRecord)node.getRecord();
            DataQueryResultItem item = new DataQueryResultItem(this.query);
            item.setRecord(record);
            item.setRecordId(record.getId());
            item.setNode(node);
            item.setNodeIndex(node.getIndex());
            item.setParentEntityId(node.getParent().getInternalId());
            item.setValue(new JSONValueFormatter().formatValue((Attribute)node));
            this.process(item);
        }

        public abstract void process(DataQueryResultItem var1);
    }
}

