/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.event;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.event.RecordTransaction;
import org.openforis.collect.event.SurveyCreatedEvent;
import org.openforis.collect.event.SurveyDeletedEvent;
import org.openforis.collect.event.SurveyEvent;
import org.openforis.collect.event.SurveyUpdatedEvent;
import org.openforis.collect.relational.event.InitializeRDBEvent;
import org.openforis.collect.reporting.ReportingRepositories;
import org.openforis.concurrency.Progress;
import org.openforis.concurrency.ProgressListener;
import org.openforis.rmb.KeepAlive;
import org.openforis.rmb.KeepAliveMessageHandler;

public class RepositoryEventHandler
implements KeepAliveMessageHandler<Object> {
    private static final Logger LOG = LogManager.getLogger(RepositoryEventHandler.class);
    private static final int DEFAULT_MAX_TRY_COUNT = 3;
    private static final long DEFAULT_RETRY_DELAY = 3000L;
    private ReportingRepositories repositories;
    private Map<String, Boolean> processBlockedBySurvey = new ConcurrentHashMap<String, Boolean>();
    private long retryDelay = 3000L;
    private int maxTryCount = 3;

    protected RepositoryEventHandler(ReportingRepositories repositories) {
        this.repositories = repositories;
    }

    public void handle(Object event, final KeepAlive keepAlive) {
        if (event instanceof SurveyEvent) {
            final SurveyEvent surveyEvent = (SurveyEvent)event;
            String surveyName = surveyEvent.getSurveyName();
            if (this.isIgnoringSurveyEvents(surveyName)) {
                this.logEventIgnored(surveyName);
                return;
            }
            boolean succeded = this.tryToRun(new Runnable(){

                @Override
                public void run() {
                    RepositoryEventHandler.this.handleEvent(surveyEvent, keepAlive);
                }
            }, this.maxTryCount, this.retryDelay);
            if (!succeded) {
                this.handleFailingEvent(surveyEvent, keepAlive);
            }
        }
    }

    private boolean tryToRun(Runnable runnable, int maxTries, long retryDelay) {
        for (int retryCount = 0; retryCount < maxTries; ++retryCount) {
            try {
                runnable.run();
                return true;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(retryDelay);
                    continue;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Handler interrupted", e1);
                }
            }
        }
        return false;
    }

    private void handleEvent(SurveyEvent event, KeepAlive keepAlive) {
        ProgressListener keepAliveListener = this.createProgressListener(keepAlive);
        String surveyName = event.getSurveyName();
        if (event instanceof RecordTransaction) {
            this.repositories.process((RecordTransaction)event);
        } else if (event instanceof SurveyCreatedEvent) {
            this.repositories.createRepositories(surveyName, null, keepAliveListener);
        } else if (event instanceof SurveyUpdatedEvent) {
            this.repositories.updateRepositories(surveyName, null, keepAliveListener);
        } else if (event instanceof SurveyDeletedEvent) {
            this.repositories.deleteRepositories(surveyName);
        } else if (event instanceof InitializeRDBEvent) {
            this.repositories.createRepository(surveyName, ((InitializeRDBEvent)event).getStep(), null, keepAliveListener);
        }
    }

    private ProgressListener createProgressListener(final KeepAlive keepAlive) {
        ProgressListener keepAliveListener = new ProgressListener(){

            public void progressMade(Progress progress) {
                keepAlive.send();
            }
        };
        return keepAliveListener;
    }

    private void handleFailingEvent(SurveyEvent event, KeepAlive keepAlive) {
        String surveyName = event.getSurveyName();
        if (event instanceof RecordTransaction) {
            try {
                ProgressListener keepAliveListener = this.createProgressListener(keepAlive);
                this.repositories.deleteRepositories(surveyName);
                this.repositories.createRepositories(surveyName, null, keepAliveListener);
                this.handleEvent(event, keepAlive);
                this.considerSurveyEvents(surveyName);
            }
            catch (Exception e) {
                this.logEventProcessFailed(event, e);
                this.ignoreSurveyEvents(surveyName);
            }
        } else {
            this.logEventIgnored(surveyName);
            this.ignoreSurveyEvents(surveyName);
        }
    }

    private void ignoreSurveyEvents(String surveyName) {
        this.processBlockedBySurvey.put(surveyName, true);
    }

    private void considerSurveyEvents(String surveyName) {
        this.processBlockedBySurvey.remove(surveyName);
    }

    private boolean isIgnoringSurveyEvents(String surveyName) {
        return this.processBlockedBySurvey.containsKey(surveyName);
    }

    private void logEventIgnored(String surveyName) {
        List<String> rdbFileNames = this.repositories.getRepositoryPaths(surveyName);
        LOG.error(String.format("Survey event ignored for survey '%s'; reporting repository is in a inconsistent state; delete the reporting repository to force its recreation: %s", surveyName, rdbFileNames));
    }

    private void logEventProcessFailed(SurveyEvent event, Exception e) {
        List<String> rdbFileNames = this.repositories.getRepositoryPaths(event.getSurveyName());
        LOG.error(String.format("Failed to process survey event %s; reporting repository is in a inconsistent state; delete the reporting repository to force its recreation: %s", event, rdbFileNames), (Throwable)e);
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxTryCount = maxRetryCount;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }
}

