/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openforis.collect.Proxy;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.manager.MessageSource;
import org.openforis.collect.model.proxy.AttributeProxy;
import org.openforis.collect.model.proxy.CodeAttributeProxy;
import org.openforis.collect.model.proxy.EntityProxy;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.CodeAttribute;
import org.openforis.idm.model.Entity;
import org.openforis.idm.model.Node;

public class NodeProxy
implements Proxy {
    private transient Node<?> node;
    protected transient ProxyContext context;

    public static NodeProxy fromNode(Node<?> node, ProxyContext context) {
        return NodeProxy.fromNode(null, node, context);
    }

    public static NodeProxy fromNode(EntityProxy parent, Node<?> node, ProxyContext context) {
        if (node instanceof Attribute) {
            if (node instanceof CodeAttribute) {
                return new CodeAttributeProxy(parent, (CodeAttribute)node, context);
            }
            return new AttributeProxy(parent, (Attribute)node, context);
        }
        if (node instanceof Entity) {
            return new EntityProxy(parent, (Entity)node, context);
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    public static List<NodeProxy> fromList(EntityProxy parent, List<Node<?>> list, ProxyContext context) {
        ArrayList<NodeProxy> result = new ArrayList<NodeProxy>();
        if (list != null) {
            for (Node<?> node : list) {
                NodeProxy proxy = NodeProxy.fromNode(node, context);
                proxy = node instanceof Attribute ? (node instanceof CodeAttribute ? new CodeAttributeProxy(parent, (CodeAttribute)node, context) : new AttributeProxy(parent, (Attribute)node, context)) : new EntityProxy(parent, (Entity)node, context);
                result.add(proxy);
            }
        }
        return result;
    }

    public NodeProxy(EntityProxy parent, Node<?> node, ProxyContext context) {
        this.node = node;
        this.context = context;
    }

    public Integer getId() {
        return this.node.getInternalId();
    }

    public Integer getDefinitionId() {
        return this.node.getDefinition() == null ? null : Integer.valueOf(this.node.getDefinition().getId());
    }

    public String getPath() {
        return this.node.getPath();
    }

    public Integer getParentId() {
        return this.node.getParent() == null ? null : this.node.getParent().getInternalId();
    }

    public boolean isUserSpecified() {
        return this.node.isUserSpecified();
    }

    protected MessageSource getMessageSource() {
        return this.context.getMessageSource();
    }

    protected Locale getLocale() {
        return this.context.getLocale();
    }
}

