/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.metamodel;

import java.util.Locale;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.zkoss.util.resource.Labels;

public enum NodeType {
    ENTITY,
    ATTRIBUTE;


    public String getLabel() {
        String labelKey;
        switch (this) {
            case ATTRIBUTE: {
                labelKey = "survey.schema.node.type.attribute";
                break;
            }
            case ENTITY: {
                labelKey = "survey.schema.node.type.entity";
                break;
            }
            default: {
                throw new IllegalArgumentException("Standard not supported: " + this.name());
            }
        }
        return Labels.getLabel((String)labelKey);
    }

    public static String getHeaderLabel(NodeDefinition nodeDefn, boolean rootEntity, boolean detached) {
        String result;
        Object[] args;
        String nodeTypeLabel = null;
        NodeType nodeType = NodeType.valueOf(nodeDefn);
        switch (nodeType) {
            case ENTITY: {
                String messageKey = rootEntity ? "survey.schema.node_detail_title.root_entity" : "survey.schema.node_detail_title.entity";
                nodeTypeLabel = Labels.getLabel((String)messageKey);
                break;
            }
            case ATTRIBUTE: {
                String messageKey = "survey.schema.node_detail_title.attribute";
                AttributeType attrType = AttributeType.valueOf((AttributeDefinition)nodeDefn);
                args = new String[]{attrType.getLabel()};
                nodeTypeLabel = Labels.getLabel((String)messageKey, (Object[])args);
            }
        }
        if (detached) {
            args = new String[]{nodeTypeLabel.toLowerCase(Locale.ENGLISH)};
            result = Labels.getLabel((String)"survey.schema.node_detail_title.new_node", (Object[])args);
        } else {
            result = nodeTypeLabel;
        }
        return result;
    }

    public static NodeType valueOf(NodeDefinition nodeDefn) {
        if (nodeDefn instanceof EntityDefinition) {
            return ENTITY;
        }
        return ATTRIBUTE;
    }

    public static <T extends NodeDefinition> T createNodeDefinition(Survey survey, NodeType nodeType, AttributeType attrType) {
        return NodeType.createNodeDefinition(survey, nodeType, attrType, null);
    }

    public static <T extends NodeDefinition> T createNodeDefinition(Survey survey, NodeType nodeType, AttributeType attrType, Integer id) {
        EntityDefinition result;
        Schema schema = survey.getSchema();
        block0 : switch (nodeType) {
            case ENTITY: {
                if (id == null) {
                    result = schema.createEntityDefinition();
                    break;
                }
                result = schema.createEntityDefinition(id.intValue());
                break;
            }
            case ATTRIBUTE: {
                switch (attrType) {
                    case BOOLEAN: {
                        if (id == null) {
                            result = schema.createBooleanAttributeDefinition();
                            break block0;
                        }
                        result = schema.createBooleanAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case CODE: {
                        if (id == null) {
                            result = schema.createCodeAttributeDefinition();
                            break block0;
                        }
                        result = schema.createCodeAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case COORDINATE: {
                        if (id == null) {
                            result = schema.createCoordinateAttributeDefinition();
                            break block0;
                        }
                        result = schema.createCoordinateAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case DATE: {
                        if (id == null) {
                            result = schema.createDateAttributeDefinition();
                            break block0;
                        }
                        result = schema.createDateAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case FILE: {
                        if (id == null) {
                            result = schema.createFileAttributeDefinition();
                            break block0;
                        }
                        result = schema.createFileAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case NUMBER: {
                        if (id == null) {
                            result = schema.createNumberAttributeDefinition();
                            break block0;
                        }
                        result = schema.createNumberAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case RANGE: {
                        if (id == null) {
                            result = schema.createRangeAttributeDefinition();
                            break block0;
                        }
                        result = schema.createRangeAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case TAXON: {
                        if (id == null) {
                            result = schema.createTaxonAttributeDefinition();
                            break block0;
                        }
                        result = schema.createTaxonAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case TEXT: {
                        if (id == null) {
                            result = schema.createTextAttributeDefinition();
                            break block0;
                        }
                        result = schema.createTextAttributeDefinition(id.intValue());
                        break block0;
                    }
                    case TIME: {
                        if (id == null) {
                            result = schema.createTimeAttributeDefinition();
                            break block0;
                        }
                        result = schema.createTimeAttributeDefinition(id.intValue());
                        break block0;
                    }
                }
                throw new IllegalStateException("Attribute type not supported: " + (Object)((Object)attrType));
            }
            default: {
                throw new IllegalStateException("Node type not supported: " + (Object)((Object)nodeType));
            }
        }
        NodeType.setDefaults((NodeDefinition)result);
        return (T)result;
    }

    private static void setDefaults(NodeDefinition result) {
        result.setAlwaysRequired();
    }
}

