/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.util;

import org.apache.commons.lang3.StringUtils;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Messagebox;

public class MessageUtil {
    protected static final String DEFAULT_CONFIRM_TITLE_KEY = "global.confirm.title";
    protected static final String DEFAULT_INFO_TITLE_KEY = "global.message.title.info";
    protected static final String DEFAULT_WARNING_TITLE_KEY = "global.message.title.warning";
    protected static final String DEFAULT_ERROR_TITLE_KEY = "global.message.title.error";

    public static void showInfo(String messageKey, Object ... args) {
        MessageUtil.showMessage(MessageType.INFO, messageKey, args);
    }

    public static void showError(String messageKey, Object ... args) {
        MessageUtil.showMessage(MessageType.ERROR, messageKey, args);
    }

    public static void showWarning(String messageKey, Object ... args) {
        MessageUtil.showMessage(MessageType.WARNING, messageKey, args);
    }

    public static void showMessage(MessageType type, String messageKey, Object ... args) {
        String titleKey;
        switch (type) {
            case ERROR: {
                titleKey = DEFAULT_ERROR_TITLE_KEY;
                break;
            }
            case WARNING: {
                titleKey = DEFAULT_WARNING_TITLE_KEY;
                break;
            }
            default: {
                titleKey = DEFAULT_INFO_TITLE_KEY;
            }
        }
        MessageUtil.showMessage(type, messageKey, args, titleKey, null);
    }

    public static void showMessage(MessageType type, String messageKey, Object[] args, String titleKey, Object[] titleArgs) {
        String icon;
        String title;
        String message = MessageUtil.getLabel(messageKey, args);
        if (message == null) {
            message = messageKey;
        }
        if ((title = MessageUtil.getLabel(titleKey, titleArgs)) == null) {
            title = titleKey;
        }
        switch (type) {
            case ERROR: {
                icon = "z-msgbox z-msgbox-error";
                break;
            }
            case WARNING: {
                icon = "z-msgbox z-msgbox-exclamation";
                break;
            }
            default: {
                icon = "z-msgbox z-msgbox-information";
            }
        }
        Messagebox.show((String)message, (String)title, (int)1, (String)icon);
    }

    public static void showConfirm(ConfirmHandler handler, String messageKey) {
        MessageUtil.showConfirm(handler, messageKey, null);
    }

    public static void showConfirm(ConfirmHandler handler, String messageKey, Object[] args) {
        MessageUtil.showConfirm(handler, messageKey, args, DEFAULT_CONFIRM_TITLE_KEY, null, null, null);
    }

    public static void showConfirm(ConfirmHandler handler, String messageKey, Object[] args, String titleKey, Object[] titleArgs, String okLabelKey, String cancelLabelKey) {
        ConfirmParams params = new ConfirmParams(handler, messageKey);
        params.setMessageArgs(args);
        params.setTitleKey(titleKey);
        params.setTitleArgs(titleArgs);
        params.setOkLabelKey(okLabelKey);
        params.setCancelLabelKey(cancelLabelKey);
        MessageUtil.showConfirm(params);
    }

    public static void showConfirm(ConfirmParams params) {
        String message = MessageUtil.getLabel(params.getMessageKey(), params.getMessageArgs());
        String title = MessageUtil.getLabel(params.getTitleKey() == null ? DEFAULT_CONFIRM_TITLE_KEY : params.getTitleKey(), params.getTitleArgs());
        ConfirmEventListener eventListener = new ConfirmEventListener(params.getConfirmHandler());
        String okLabel = MessageUtil.getLabel(params.getOkLabelKey(), new Object[0]);
        String cancelLabel = MessageUtil.getLabel(params.getCancelLabelKey(), new Object[0]);
        String[] btnLabels = null;
        if (StringUtils.isNotBlank((CharSequence)okLabel)) {
            btnLabels = StringUtils.isNotBlank((CharSequence)cancelLabel) ? new String[]{okLabel, cancelLabel} : new String[]{okLabel};
        }
        Messagebox.show((String)message, (String)title, (Messagebox.Button[])new Messagebox.Button[]{Messagebox.Button.OK, Messagebox.Button.CANCEL}, (String[])btnLabels, (String)"z-msgbox z-msgbox-question", (Messagebox.Button)Messagebox.Button.CANCEL, (EventListener)eventListener);
    }

    protected static String getLabel(String key, Object ... args) {
        String label = Labels.getLabel((String)key, (Object[])args);
        if (label != null) {
            label = label.replaceAll("\\\\n", "\n");
        }
        return label;
    }

    public static class ConfirmParams {
        private ConfirmHandler confirmHandler;
        private String messageKey;
        private Object[] messageArgs;
        private String titleKey;
        private Object[] titleArgs;
        private String okLabelKey;
        private String cancelLabelKey;

        public ConfirmParams(ConfirmHandler confirmHandler) {
            this(confirmHandler, null);
        }

        public ConfirmParams(ConfirmHandler confirmHandler, String messageKey) {
            this.confirmHandler = confirmHandler;
            this.messageKey = messageKey;
        }

        public void setMessage(String key, Object ... args) {
            this.messageKey = key;
            this.messageArgs = args;
        }

        public void setTitle(String key, Object ... args) {
            this.titleKey = key;
            this.titleArgs = args;
        }

        public ConfirmHandler getConfirmHandler() {
            return this.confirmHandler;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public void setMessageKey(String messageKey) {
            this.messageKey = messageKey;
        }

        public String getTitleKey() {
            return this.titleKey;
        }

        public void setTitleKey(String titleKey) {
            this.titleKey = titleKey;
        }

        public Object[] getTitleArgs() {
            return this.titleArgs;
        }

        public void setTitleArgs(Object[] titleArgs) {
            this.titleArgs = titleArgs;
        }

        public String getOkLabelKey() {
            return this.okLabelKey;
        }

        public void setOkLabelKey(String okLabelKey) {
            this.okLabelKey = okLabelKey;
        }

        public String getCancelLabelKey() {
            return this.cancelLabelKey;
        }

        public void setCancelLabelKey(String cancelLabelKey) {
            this.cancelLabelKey = cancelLabelKey;
        }

        public Object[] getMessageArgs() {
            return this.messageArgs;
        }

        public void setMessageArgs(Object[] messageArgs) {
            this.messageArgs = messageArgs;
        }
    }

    public static interface CompleteConfirmHandler
    extends ConfirmHandler {
        public void onCancel();
    }

    public static interface ConfirmHandler {
        public void onOk();
    }

    static class ConfirmEventListener
    implements EventListener<Messagebox.ClickEvent> {
        private ConfirmHandler handler;

        public ConfirmEventListener(ConfirmHandler handler) {
            this.handler = handler;
        }

        public void onEvent(Messagebox.ClickEvent evt) throws InterruptedException {
            String evtName = evt.getName();
            if ("onOK".equals(evtName)) {
                this.handler.onOk();
            } else if (this.handler instanceof CompleteConfirmHandler && "onCancel".equals(evtName)) {
                ((CompleteConfirmHandler)this.handler).onCancel();
            }
        }
    }

    public static enum MessageType {
        INFO,
        WARNING,
        ERROR;

    }
}

