/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.codelist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.io.metadata.codelist.CodeListExportTask;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.CodeList;

public class CodeListBatchExportJob
extends Job {
    private CollectSurvey survey;
    private CodeListManager codeListManager;
    private File outputFile;
    private ZipOutputStream zipOutputStream;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.outputFile = File.createTempFile("batch_code_list_export", ".zip");
        this.zipOutputStream = new ZipOutputStream(new FileOutputStream(this.outputFile));
    }

    protected void buildTasks() throws Throwable {
        CodeList samplingDesignCodeList = this.survey.getSamplingDesignCodeList();
        for (CodeList codeList : this.survey.getCodeLists()) {
            if (codeList.getId() == samplingDesignCodeList.getId()) continue;
            this.addCodeListExportTask(codeList);
        }
    }

    private void addCodeListExportTask(CodeList codeList) {
        CodeListExportTask t = new CodeListExportTask();
        t.setOut(this.zipOutputStream);
        t.setList(codeList);
        t.setCodeListManager(this.codeListManager);
        this.addTask((Worker)t);
    }

    protected void initializeTask(Worker task) {
        CodeList codeList = ((CodeListExportTask)task).getList();
        String zipEntryName = codeList.getName() + ".csv";
        try {
            this.zipOutputStream.putNextEntry(new ZipEntry(zipEntryName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.initializeTask(task);
    }

    protected void onTaskCompleted(Worker task) {
        super.onTaskCompleted(task);
        try {
            this.zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void onCompleted() {
        super.onCompleted();
        IOUtils.closeQuietly((OutputStream)this.zipOutputStream);
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setCodeListManager(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

