/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SamplingDesignManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.EntityAddChange;
import org.openforis.collect.model.NodeChange;
import org.openforis.collect.model.NodeChangeSet;
import org.openforis.collect.model.RecordUpdater;
import org.openforis.collect.model.SamplingDesignItem;
import org.openforis.collect.model.User;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Code;
import org.openforis.idm.model.CodeAttribute;
import org.openforis.idm.model.Entity;
import org.openforis.idm.model.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RecordGenerator {
    @Autowired
    RecordManager recordManager;
    @Autowired
    SurveyManager surveyManager;
    @Autowired
    UserManager userManager;
    @Autowired
    SamplingDesignManager samplingDesignManager;
    RecordUpdater recordUpdater = new RecordUpdater();

    @Transactional
    public CollectRecord generate(CollectSurvey survey, NewRecordParameters parameters) {
        List<AttributeDefinition> keyDefs = this.getKeyAttributeDefs(survey);
        RecordKey recordKey = new RecordKey(keyDefs, parameters.getRecordKey());
        return this.generate(survey, parameters, recordKey);
    }

    @Transactional
    public CollectRecord generate(CollectSurvey survey, NewRecordParameters parameters, RecordKey recordKey) {
        User user = this.loadUser(parameters.getUserId(), parameters.getUsername());
        EntityDefinition rootEntityDef = StringUtils.isBlank((CharSequence)parameters.getRootEntityName()) ? survey.getSchema().getFirstRootEntityDefinition() : survey.getSchema().getRootEntityDefinition(parameters.getRootEntityName());
        CollectRecord record = this.createRecord(survey, rootEntityDef, parameters.getVersionId(), parameters.getStep(), user, recordKey);
        record.setPreview(parameters.isPreview());
        if (parameters.isAddSecondLevelEntities()) {
            this.addSecondLevelEntities(record, recordKey);
        }
        if (!record.isPreview()) {
            this.recordManager.save(record);
        }
        return record;
    }

    private CollectRecord createRecord(CollectSurvey survey, EntityDefinition rootEntityDef, Integer versionId, CollectRecord.Step step, User user, RecordKey recordKey) {
        String rootEntityName = rootEntityDef.getName();
        ModelVersion version = versionId == null ? null : survey.getVersionById(versionId.intValue());
        String versionName = version == null ? null : version.getName();
        CollectRecord record = this.recordManager.create(survey, rootEntityName, user, versionName, null, step);
        if (recordKey.isNotEmpty()) {
            this.setRecordKeyValues(record, recordKey);
        }
        return record;
    }

    private void addSecondLevelEntities(CollectRecord record, RecordKey recordKey) {
        CollectSurvey survey = (CollectSurvey)record.getSurvey();
        List<AttributeDefinition> nonMeasurementKeyDefs = this.getNonMeasurementKeyDefs(survey);
        List<String> keyValues = recordKey.getValues(nonMeasurementKeyDefs);
        List secondLevelSamplingPointItems = this.samplingDesignManager.loadChildItems(survey.getId().intValue(), keyValues);
        List<CodeAttributeDefinition> samplingPointDataCodeAttributeDefs = this.findSamplingPointCodeAttributes(survey);
        if (!secondLevelSamplingPointItems.isEmpty() && samplingPointDataCodeAttributeDefs.size() > 1) {
            int levelIndex = 1;
            for (SamplingDesignItem samplingDesignItem : secondLevelSamplingPointItems) {
                CodeAttributeDefinition levelKeyDef = samplingPointDataCodeAttributeDefs.get(levelIndex);
                EntityDefinition levelEntityDef = levelKeyDef.getParentEntityDefinition();
                Entity parentLevelEntity = record.getRootEntity();
                NodeChangeSet addEntityChangeSet = this.recordUpdater.addEntity(parentLevelEntity, levelEntityDef);
                Entity entity = this.getAddedEntity(addEntityChangeSet);
                CodeAttribute keyAttr = (CodeAttribute)entity.getChild((NodeDefinition)levelKeyDef);
                this.recordUpdater.updateAttribute((Attribute)keyAttr, (Value)new Code(samplingDesignItem.getLevelCode(levelIndex + 1)));
            }
        }
    }

    private void setRecordKeyValues(CollectRecord record, RecordKey recordKey) {
        CollectSurvey survey = (CollectSurvey)record.getSurvey();
        List keyAttributeDefs = survey.getSchema().getFirstRootEntityDefinition().getKeyAttributeDefinitions();
        for (AttributeDefinition keyAttrDef : keyAttributeDefs) {
            String keyPart = recordKey.getValue(keyAttrDef.getPath());
            Attribute keyAttribute = (Attribute)record.findNodeByPath(keyAttrDef.getPath());
            Value value = keyAttrDef.createValue(keyPart);
            this.recordUpdater.updateAttribute(keyAttribute, value);
        }
    }

    private List<CodeAttributeDefinition> findSamplingPointCodeAttributes(final CollectSurvey survey) {
        EntityDefinition rootEntityDef = survey.getSchema().getFirstRootEntityDefinition();
        final ArrayList<CodeAttributeDefinition> samplingPointDataCodeAttributeDefs = new ArrayList<CodeAttributeDefinition>();
        rootEntityDef.traverse(new NodeDefinitionVisitor(){

            public void visit(NodeDefinition def) {
                if (def instanceof CodeAttributeDefinition && ((CodeAttributeDefinition)def).getList().equals((Object)survey.getSamplingDesignCodeList())) {
                    samplingPointDataCodeAttributeDefs.add((CodeAttributeDefinition)def);
                }
            }
        }, EntityDefinition.TraversalType.BFS);
        return samplingPointDataCodeAttributeDefs;
    }

    private Entity getAddedEntity(NodeChangeSet changeSet) {
        List changes = changeSet.getChanges();
        for (NodeChange nodeChange : changes) {
            if (!(nodeChange instanceof EntityAddChange)) continue;
            Entity entity = (Entity)nodeChange.getNode();
            return entity;
        }
        throw new IllegalArgumentException("Cannot find added entity in node change set");
    }

    protected List<AttributeDefinition> getKeyAttributeDefs(CollectSurvey survey) {
        EntityDefinition rootEntityDef = survey.getSchema().getFirstRootEntityDefinition();
        return rootEntityDef.getKeyAttributeDefinitions();
    }

    protected List<AttributeDefinition> getMeasurementKeyDefs(CollectSurvey survey) {
        List<AttributeDefinition> keyAttrDefs = this.getKeyAttributeDefs(survey);
        ArrayList<AttributeDefinition> measurementKeyAttrDefs = new ArrayList<AttributeDefinition>();
        for (AttributeDefinition keyAttrDef : keyAttrDefs) {
            if (!survey.getAnnotations().isMeasurementAttribute(keyAttrDef)) continue;
            measurementKeyAttrDefs.add(keyAttrDef);
        }
        return measurementKeyAttrDefs;
    }

    protected List<AttributeDefinition> getNonMeasurementKeyDefs(CollectSurvey survey) {
        List<AttributeDefinition> keyAttrDefs = this.getKeyAttributeDefs(survey);
        List<AttributeDefinition> measurementKeyDefs = this.getMeasurementKeyDefs(survey);
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>(keyAttrDefs);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            AttributeDefinition keyDef = (AttributeDefinition)it.next();
            if (!measurementKeyDefs.contains(keyDef)) continue;
            it.remove();
        }
        return result;
    }

    protected User loadUser(Integer userId, String username) {
        if (userId != null) {
            return (User)this.userManager.loadById((Object)userId);
        }
        if (username != null) {
            return this.userManager.loadByUserName(username);
        }
        return null;
    }

    public static class RecordKey {
        private Map<String, String> valueByPath = new HashMap<String, String>();

        public RecordKey() {
        }

        public List<String> getValues(List<AttributeDefinition> keyDefs) {
            List<String> values = keyDefs.stream().map(keyDef -> this.valueByPath.get(keyDef.getPath())).collect(Collectors.toList());
            return values;
        }

        public RecordKey(List<AttributeDefinition> keyDefs, List<String> keys) {
            for (int i = 0; i < keyDefs.size() && i < keys.size(); ++i) {
                AttributeDefinition def = keyDefs.get(i);
                this.putValue(def.getPath(), keys.get(i));
            }
        }

        public String getValue(String path) {
            return this.valueByPath.get(path);
        }

        public void putValue(String path, String value) {
            this.valueByPath.put(path, value);
        }

        public boolean isNotEmpty() {
            return !this.valueByPath.isEmpty();
        }

        public Map<String, String> getValueByPath() {
            return this.valueByPath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.valueByPath == null ? 0 : this.valueByPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RecordKey other = (RecordKey)obj;
            return !(this.valueByPath == null ? other.valueByPath != null : !this.valueByPath.equals(other.valueByPath));
        }
    }

    public static class NewRecordParameters {
        private String username;
        private Integer userId;
        private String rootEntityName;
        private Integer versionId;
        private CollectRecord.Step step = CollectRecord.Step.ENTRY;
        private boolean preview;
        private boolean addSecondLevelEntities = false;
        private boolean onlyUnanalyzedSamplingPoints = false;
        private List<String> recordKey = new ArrayList<String>();

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public String getRootEntityName() {
            return this.rootEntityName;
        }

        public void setRootEntityName(String rootEntityName) {
            this.rootEntityName = rootEntityName;
        }

        public Integer getVersionId() {
            return this.versionId;
        }

        public void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        public CollectRecord.Step getStep() {
            return this.step;
        }

        public void setStep(CollectRecord.Step step) {
            this.step = step;
        }

        public boolean isPreview() {
            return this.preview;
        }

        public void setPreview(boolean preview) {
            this.preview = preview;
        }

        public boolean isAddSecondLevelEntities() {
            return this.addSecondLevelEntities;
        }

        public void setAddSecondLevelEntities(boolean addSecondLevelEntities) {
            this.addSecondLevelEntities = addSecondLevelEntities;
        }

        public boolean isOnlyUnanalyzedSamplingPoints() {
            return this.onlyUnanalyzedSamplingPoints;
        }

        public void setOnlyUnanalyzedSamplingPoints(boolean onlyUnanalyzedSamplingPoints) {
            this.onlyUnanalyzedSamplingPoints = onlyUnanalyzedSamplingPoints;
        }

        public List<String> getRecordKey() {
            return this.recordKey;
        }

        public void setRecordKey(List<String> recordKey) {
            this.recordKey = recordKey;
        }
    }
}

