/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.TaxonAttributeDefinitionFormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.AttributeVM;
import org.openforis.collect.manager.SpeciesManager;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.openforis.idm.model.species.Taxon;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class TaxonAttributeVM
extends AttributeVM<TaxonAttributeDefinition> {
    private static final String QUALIFIERS_FIELD = "qualifiers";
    private static final Taxon.TaxonRank[] AVAILABLE_HIGHEST_RANKS = new Taxon.TaxonRank[]{Taxon.TaxonRank.FAMILY, Taxon.TaxonRank.GENUS, Taxon.TaxonRank.SPECIES};
    @WireVariable
    private SpeciesManager speciesManager;
    private List<String> qualifiers;
    private String selectedQualifier;

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="parentEntity") EntityDefinition parentEntity, @ExecutionArgParam(value="item") TaxonAttributeDefinition attributeDefn, @ExecutionArgParam(value="newItem") Boolean newItem) {
        super.initInternal(parentEntity, attributeDefn, newItem);
    }

    @Command
    @NotifyChange(value={"qualifiers"})
    public void addQualifier() {
        if (this.qualifiers == null) {
            this.initQualifiersList();
        }
        if (this.qualifiers.contains("")) {
            MessageUtil.showWarning("survey.schema.attribute.taxon.duplicated_qualifier", new Object[0]);
        } else {
            this.qualifiers.add("");
        }
    }

    @Command
    @NotifyChange(value={"selectedQualifier", "qualifiers"})
    public void updateQualifier(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="text") String text) {
        int index = this.qualifiers.indexOf(this.selectedQualifier);
        if (this.qualifiers.contains(text) && !this.selectedQualifier.equals(text)) {
            MessageUtil.showWarning("survey.schema.attribute.taxon.duplicated_qualifier", new Object[0]);
        } else {
            this.qualifiers.set(index, text);
            this.dispatchApplyChangesCommand(binder);
        }
    }

    @Command
    @NotifyChange(value={"selectedQualifier", "qualifiers"})
    public void deleteQualifier() {
        this.qualifiers.remove(this.selectedQualifier);
        this.selectedQualifier = null;
    }

    @Command
    @NotifyChange(value={"selectedQualifier"})
    public void selectQualifier(@BindingParam(value="qualifier") String qualifier) {
        this.selectedQualifier = qualifier;
    }

    protected void initQualifiersList() {
        if (this.qualifiers == null) {
            this.qualifiers = new ArrayList<String>();
            this.setTempFormObjectFieldValue(QUALIFIERS_FIELD, this.qualifiers);
            ((TaxonAttributeDefinitionFormObject)this.formObject).setQualifiers(this.qualifiers);
        }
    }

    @Override
    public void setEditedItem(TaxonAttributeDefinition editedItem) {
        super.setEditedItem(editedItem);
        if (editedItem != null) {
            this.qualifiers = ((TaxonAttributeDefinitionFormObject)this.formObject).getQualifiers();
            this.setTempFormObjectFieldValue(QUALIFIERS_FIELD, this.qualifiers);
        }
    }

    public List<String> getRanks() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(Labels.getLabel((String)"global.empty_option"));
        for (int i = 0; i < AVAILABLE_HIGHEST_RANKS.length; ++i) {
            Taxon.TaxonRank rank = AVAILABLE_HIGHEST_RANKS[i];
            result.add(rank.getName());
        }
        return result;
    }

    public String getRankLabel(String name) {
        String labelKey = "survey.schema.attribute.taxon.rank." + name.toLowerCase(Locale.ENGLISH);
        String label = Labels.getLabel((String)labelKey);
        return label;
    }

    public List<String[]> getVisibleFieldsTemplates() {
        ArrayList<String[]> result = new ArrayList<String[]>(UIOptions.TAXON_VISIBLE_FIELDS_TEMPLATES);
        List fieldNames = ((TaxonAttributeDefinition)this.editedItem).getFieldNames();
        result.add(0, fieldNames.toArray(new String[fieldNames.size()]));
        return result;
    }

    public String getVisibleFieldsTemplateLabel(String[] template) {
        if (template == null || template.length == ((TaxonAttributeDefinition)this.editedItem).getFieldDefinitions().size()) {
            return Labels.getLabel((String)"survey.schema.attribute.visible_fields.all_item");
        }
        return StringUtils.join((Object[])template, (String)",");
    }

    public List<String> getQualifiers() {
        return this.qualifiers;
    }

    public String getSelectedQualifier() {
        return this.selectedQualifier;
    }

    public void setSelectedQualifier(String selectedQualifier) {
        this.selectedQualifier = selectedQualifier;
    }
}

