/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openforis.collect.designer.form.AttributeFormObject;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.form.TaxonomyFormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.ReferenceDataAttributesEditor;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyEditVM;
import org.openforis.collect.designer.viewmodel.SurveyErrorsPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.designer.viewmodel.TaxonomyImportPopUpVM;
import org.openforis.collect.io.metadata.ReferenceDataExportOutputFormat;
import org.openforis.collect.io.metadata.species.SpeciesExportJob;
import org.openforis.collect.io.metadata.species.SpeciesFileColumn;
import org.openforis.collect.manager.SpeciesManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.metamodel.TaxonSummaries;
import org.openforis.collect.metamodel.TaxonSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.CollectTaxonomy;
import org.openforis.collect.utils.Dates;
import org.openforis.concurrency.Job;
import org.openforis.idm.metamodel.Languages;
import org.openforis.idm.metamodel.ReferenceDataSchema;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Window;

public class TaxonomiesVM
extends SurveyObjectBaseVM<CollectTaxonomy> {
    public static final String EDITING_ATTRIBUTE_PARAM = "editingAttribute";
    public static final String SELECTED_TAXONOMY_PARAM = "selectedTaxonomy";
    private static final String TAXONOMY_UPDATED_COMMAND = "taxonomyUpdated";
    private static final String CLOSE_TAXONOMY_IMPORT_POP_UP_COMMAND = "closeTaxonomyImportPopUp";
    private static final int TAXA_PAGE_SIZE = 30;
    private static final String RANK_COL_NAME = "rank";
    private static final String LAT_LANG_CODE = "lat";
    private static final String COL_WIDTH_INFO_ATTRIBUTE = "150px";
    private static final String COL_WIDTH_SCIENTIFIC_NAME = "250px";
    private static final String COL_WIDTH_VERNACULAR_NAME = "150px";
    private final Map<String, String> WIDTH_BY_COL_NAME = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(SpeciesFileColumn.CODE.getColumnName(), "120px");
            this.put(SpeciesFileColumn.SCIENTIFIC_NAME.getColumnName(), TaxonomiesVM.COL_WIDTH_SCIENTIFIC_NAME);
            this.put(TaxonomiesVM.RANK_COL_NAME, "80px");
            this.put(SpeciesFileColumn.SYNONYMS.getColumnName(), TaxonomiesVM.COL_WIDTH_SCIENTIFIC_NAME);
        }
    };
    @WireVariable
    private SurveyManager surveyManager;
    @WireVariable
    private SpeciesManager speciesManager;
    protected boolean editingAttribute;
    private Window taxonomyImportPopUp;
    private Window dataImportErrorPopUp;
    private Window referencedNodesPopUp;
    private ReferenceDataAttributesEditor referenceDataAttributesEditor;
    private int taxaPage;
    private TaxonSummaries taxonSummaries;

    public static void dispatchTaxonomyUpdatedCommand(int taxonomyId) {
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("taxonomyId", taxonomyId);
        BindUtils.postGlobalCommand(null, null, (String)TAXONOMY_UPDATED_COMMAND, args);
    }

    public static void dispatchCloseTaxonomyImportPopUpCommand() {
        BindUtils.postGlobalCommand(null, null, (String)CLOSE_TAXONOMY_IMPORT_POP_UP_COMMAND, null);
    }

    public TaxonomiesVM() {
        this.formObject = this.createFormObject();
        this.fieldLabelKeyPrefixes.addAll(0, Arrays.asList("survey.taxonomy"));
    }

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="editingAttribute") Boolean editingAttribute, @ExecutionArgParam(value="selectedTaxonomy") CollectTaxonomy selectedTaxonomy) {
        super.init();
        if (selectedTaxonomy != null) {
            this.selectionChanged(selectedTaxonomy);
        }
        this.editingAttribute = editingAttribute != null && editingAttribute != false;
    }

    @Override
    protected List<CollectTaxonomy> getItemsInternal() {
        CollectSurvey survey = this.getSurvey();
        if (survey == null) {
            return Collections.emptyList();
        }
        return this.speciesManager.loadTaxonomiesBySurvey(survey);
    }

    @Override
    protected FormObject<CollectTaxonomy> createFormObject() {
        return new TaxonomyFormObject();
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
    }

    @Override
    protected CollectTaxonomy createItemInstance() {
        CollectTaxonomy taxonomy = new CollectTaxonomy();
        taxonomy.setSurvey(this.getSurvey());
        return taxonomy;
    }

    @Override
    protected void addNewItemToSurvey() {
        ReferenceDataSchema referenceDataSchema = this.getSurvey().getReferenceDataSchema();
        referenceDataSchema.addTaxonomyDefinition(new ReferenceDataSchema.TaxonomyDefinition(((CollectTaxonomy)this.editedItem).getName()));
        this.speciesManager.save((CollectTaxonomy)this.editedItem);
        this.dispatchTaxonomiesUpdatedCommand();
        SurveyEditVM.dispatchSurveySaveCommand();
    }

    @Override
    protected void performNewItemCreation(Binder binder) {
        super.performNewItemCreation(binder);
        this.resetTaxa();
    }

    @Override
    protected void deleteItemFromSurvey(CollectTaxonomy item) {
        this.speciesManager.delete(item);
        this.getSurvey().getReferenceDataSchema().removeTaxonomyDefinition(item.getName());
        this.dispatchTaxonomiesUpdatedCommand();
    }

    @Override
    protected void performDeleteItem(CollectTaxonomy item) {
        super.performDeleteItem(item);
        SurveyEditVM.dispatchSurveySaveCommand();
    }

    @Override
    protected void performItemSelection(CollectTaxonomy item) {
        super.performItemSelection(item);
        ArrayList<String> fixedColumnNames = new ArrayList<String>();
        fixedColumnNames.addAll(Arrays.asList(SpeciesFileColumn.CODE.getColumnName(), RANK_COL_NAME, SpeciesFileColumn.SCIENTIFIC_NAME.getColumnName(), SpeciesFileColumn.SYNONYMS.getColumnName()));
        List vernacularLangCodes = this.speciesManager.loadTaxaVernacularLangCodes(item.getId().intValue());
        vernacularLangCodes.remove(LAT_LANG_CODE);
        fixedColumnNames.addAll(vernacularLangCodes);
        this.referenceDataAttributesEditor = new ReferenceDataAttributesEditor(fixedColumnNames, (ReferenceDataSchema.ReferenceDataDefinition)this.getSurvey().getReferenceDataSchema().getTaxonomyDefinition(item.getName()));
        this.notifyChange("taxaAttributes");
        this.taxaPage = 0;
        this.loadTaxa();
    }

    @Command
    public void deleteTaxonomy(@BindingParam(value="item") CollectTaxonomy item) {
        List<TaxonAttributeDefinition> references = this.getReferences(item);
        if (!references.isEmpty()) {
            String title = Labels.getLabel((String)"global.message.title.warning");
            String message = Labels.getLabel((String)"survey.taxonomy.alert.cannot_delete_used_taxonomy");
            this.referencedNodesPopUp = SurveyErrorsPopUpVM.openPopUp(title, message, references, new MessageUtil.ConfirmHandler(){

                @Override
                public void onOk() {
                    BaseVM.closePopUp(TaxonomiesVM.this.referencedNodesPopUp);
                    TaxonomiesVM.this.referencedNodesPopUp = null;
                }
            }, true);
        } else {
            super.deleteItem(item);
        }
    }

    protected List<TaxonAttributeDefinition> getReferences(CollectTaxonomy item) {
        return this.getSurvey().getSchema().getTaxonAttributeDefinitions(item.getName());
    }

    @Override
    @GlobalCommand
    public void taxonomiesUpdated() {
        this.notifyChange("items");
    }

    @GlobalCommand
    public void taxonomyUpdated(@BindingParam(value="taxonomyId") int taxonomyId) {
        if (this.isEditingItem() && ((CollectTaxonomy)this.editedItem).getId() == taxonomyId) {
            this.performItemSelection((CollectTaxonomy)this.editedItem);
        }
        this.dispatchTaxonomiesUpdatedCommand();
    }

    @Override
    public void commitChanges(@ContextParam(value=ContextType.BINDER) Binder binder) {
        String oldName = ((CollectTaxonomy)this.editedItem).getName();
        List<TaxonAttributeDefinition> references = oldName == null ? null : this.getReferences((CollectTaxonomy)this.editedItem);
        super.commitChanges(binder);
        if (oldName != null) {
            this.getSurvey().getReferenceDataSchema().updateTaxonomyDefinitionName(oldName, ((CollectTaxonomy)this.editedItem).getName());
            for (TaxonAttributeDefinition taxonAttributeDefinition : references) {
                taxonAttributeDefinition.setTaxonomy(((CollectTaxonomy)this.editedItem).getName());
            }
        }
        this.speciesManager.save((CollectTaxonomy)this.editedItem);
        this.dispatchTaxonomiesUpdatedCommand();
        SurveyEditVM.dispatchSurveySaveCommand();
    }

    @Command
    public void openImportPopUp() {
        this.taxonomyImportPopUp = TaxonomyImportPopUpVM.openPopUp(((CollectTaxonomy)this.editedItem).getId());
    }

    @Command
    public void exportToCsv() throws IOException {
        this.export(ReferenceDataExportOutputFormat.CSV);
    }

    @Command
    public void exportToExcel() throws IOException {
        this.export(ReferenceDataExportOutputFormat.EXCEL);
    }

    private void export(ReferenceDataExportOutputFormat outputFormat) throws IOException {
        SpeciesExportJob job = (SpeciesExportJob)this.jobManager.createJob(SpeciesExportJob.class);
        job.setSurvey(this.getSurvey());
        job.setTaxonomyId(((CollectTaxonomy)this.editedItem).getId().intValue());
        job.setOutputFormat(outputFormat);
        this.jobManager.start((Job)job, false);
        String contentType = outputFormat == ReferenceDataExportOutputFormat.CSV ? "text/csv" : "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        String fileName = String.format("%s_species_list_%s_%s", this.getSurvey().getName(), ((CollectTaxonomy)this.editedItem).getName(), Dates.formatCompactNow());
        Filedownload.save((InputStream)new FileInputStream(job.getOutputFile()), (String)contentType, (String)fileName);
    }

    @GlobalCommand
    public void closeReferenceDataImportErrorPopUp() {
        TaxonomiesVM.closePopUp(this.dataImportErrorPopUp);
        this.dataImportErrorPopUp = null;
    }

    @GlobalCommand
    public void closeTaxonomyImportPopUp() {
        TaxonomiesVM.closePopUp(this.taxonomyImportPopUp);
        this.taxonomyImportPopUp = null;
    }

    @GlobalCommand
    public void closeTaxonomyManagerPopUp() {
        this.resetEditedItem();
        this.taxonomiesUpdated();
    }

    @GlobalCommand
    public void taxonomyAssigned(@BindingParam(value="list") CollectTaxonomy taxonomy, @BindingParam(value="oldTaxonomy") CollectTaxonomy oldTaxonomy) {
        BindUtils.postNotifyChange(null, null, (Object)taxonomy, (String)".");
        BindUtils.postNotifyChange(null, null, (Object)oldTaxonomy, (String)".");
    }

    @Command
    public void close(@ContextParam(value=ContextType.TRIGGER_EVENT) Event event) {
        event.stopPropagation();
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(TaxonomiesVM.EDITING_ATTRIBUTE_PARAM, TaxonomiesVM.this.editingAttribute);
                params.put(TaxonomiesVM.SELECTED_TAXONOMY_PARAM, TaxonomiesVM.this.selectedItem);
                BindUtils.postGlobalCommand(null, null, (String)"closeTaxonomyManagerPopUp", params);
            }
        });
    }

    public boolean hasWarnings(CollectTaxonomy taxonomy) {
        return this.getWarnings(taxonomy) != null;
    }

    public String getWarnings(CollectTaxonomy taxonomy) {
        List<TaxonAttributeDefinition> referencingDefs = this.getReferences(taxonomy);
        String messageKey = referencingDefs.isEmpty() ? "survey.validation.error.unused_taxonomy" : (!this.speciesManager.hasTaxons(taxonomy) ? "survey.validation.error.empty_taxonomy" : null);
        return messageKey == null ? null : Labels.getLabel((String)messageKey);
    }

    public List<AttributeFormObject> getTaxaAttributes() {
        return this.isEditingItem() ? this.referenceDataAttributesEditor.getAttributes() : null;
    }

    public String getTaxaAttributeLabel(AttributeFormObject attribute) {
        String name = attribute.getName();
        if (this.isVernacularNameColumn(name)) {
            return String.format("%s (%s)", name, Labels.getLabel((String)name));
        }
        return name;
    }

    public String getTaxaAttributeColumnWith(AttributeFormObject attribute) {
        String name = attribute.getName();
        String width = this.WIDTH_BY_COL_NAME.get(name);
        if (width == null) {
            width = this.isVernacularNameColumn(name) ? "150px" : "150px";
        }
        return width;
    }

    @Command
    @NotifyChange(value={"taxaAttributes"})
    public void changeAttributeEditableStatus(@BindingParam(value="attribute") AttributeFormObject attribute) {
        this.referenceDataAttributesEditor.changeAttributeEditableStatus(attribute);
    }

    @Command
    @NotifyChange(value={"taxaAttributes"})
    public void confirmAttributeUpdate(@BindingParam(value="attribute") AttributeFormObject attribute) {
        if (this.referenceDataAttributesEditor.confirmAttributeUpdate(attribute)) {
            this.dispatchSurveyChangedCommand();
        }
    }

    public List<TaxonSummary> getTaxa() {
        return this.isEditingItem() && this.taxonSummaries != null ? this.taxonSummaries.getItems() : null;
    }

    public int getTaxaTotal() {
        return this.isEditingItem() && this.taxonSummaries != null ? this.taxonSummaries.getTotalCount() : 0;
    }

    public int getTaxaPage() {
        return this.taxaPage;
    }

    public int getTaxaPageSize() {
        return 30;
    }

    public String getTaxonAttribute(TaxonSummary taxon, String colName) {
        if (SpeciesFileColumn.CODE.getColumnName().equals(colName)) {
            return taxon.getCode();
        }
        if (RANK_COL_NAME.equals(colName)) {
            return Labels.getLabel((String)("survey.taxonomy.rank." + taxon.getRank().getName()));
        }
        if (SpeciesFileColumn.SCIENTIFIC_NAME.getColumnName().equals(colName)) {
            return taxon.getScientificName();
        }
        if (SpeciesFileColumn.SYNONYMS.getColumnName().equals(colName)) {
            return taxon.getJointSynonyms();
        }
        if (this.isVernacularNameColumn(colName)) {
            return taxon.getJointVernacularNames(colName);
        }
        return taxon.getInfo(colName);
    }

    @Command
    public void updateTaxaPaging(int newPageIndex) {
        this.taxaPage = newPageIndex;
        this.loadTaxa();
    }

    private void resetTaxa() {
        this.taxaPage = 0;
        this.taxonSummaries = null;
        this.notifyChange("taxa", "taxaTotal", "taxaPage");
    }

    private void loadTaxa() {
        this.taxonSummaries = this.speciesManager.loadTaxonSummaries(this.getSurvey(), ((CollectTaxonomy)this.editedItem).getId().intValue(), this.taxaPage * 30, 30);
        this.notifyChange("taxa", "taxaTotal", "taxaPage");
    }

    private boolean isVernacularNameColumn(String colName) {
        return Languages.exists((Languages.Standard)Languages.Standard.ISO_639_3, (String)colName);
    }
}

