/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public abstract class AbstractClient {
    public <T> T getOne(String url, Class<T> type) {
        return this.get(url, this.createSingleItemResponseProcessor(type));
    }

    public <T> List<T> getList(String url, Class<T> type) {
        return this.getList(url, null, type);
    }

    public <T> List<T> getList(String url, Map<String, Object> params, final Class<T> type) {
        if (params != null) {
            url = this.appendQueryParams(url, params);
        }
        return (List)this.get(url, new ResponseProcessor<List<T>>(){

            @Override
            public List<T> process(Reader r) {
                Object[] result = (Object[])new GsonBuilder().create().fromJson(r, TypeToken.getArray((Type)type).getType());
                return Arrays.asList(result);
            }
        });
    }

    public <T> T post(String url, Object data, Class<T> resultType) {
        return this.httpConnect(url, "POST", this.toPostData(data), this.createSingleItemResponseProcessor(resultType));
    }

    public <T> T patch(String url, Object data, Class<T> resultType) {
        return this.httpConnect(url, "PATCH", this.toPostData(data), this.createSingleItemResponseProcessor(resultType));
    }

    public void delete(String url) {
        this.httpConnect(url, "DELETE", null, new ResponseProcessor<Void>(){

            @Override
            public Void process(Reader r) {
                return null;
            }
        });
    }

    protected <R> R get(String url, ResponseProcessor<R> responseProcessor) {
        return this.httpConnect(url, "GET", null, responseProcessor);
    }

    private <T> ResponseProcessor<T> createSingleItemResponseProcessor(final Class<T> type) {
        return new ResponseProcessor<T>(){

            @Override
            public T process(Reader r) {
                Object result = new GsonBuilder().create().fromJson(r, type);
                return result;
            }
        };
    }

    private <R> R httpConnect(String url, String method, byte[] data, ResponseProcessor<R> responseProcessor) {
        HttpURLConnection c = null;
        try {
            c = (HttpURLConnection)new URL(url).openConnection();
            c.setDoOutput(true);
            c.setDoInput(true);
            c.setUseCaches(false);
            c.setRequestMethod(method);
            c.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            c.setRequestProperty("Accept", "application/json");
            if (data != null) {
                OutputStream os = c.getOutputStream();
                os.write(data);
                os.flush();
            }
            if (c.getResponseCode() != 200) {
                throw new RuntimeException(String.format("Failed to load url %s with method %s: HTTP error code : %s", url, method, c.getResponseCode()));
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(c.getInputStream()));
            R r = responseProcessor.process(br);
            return r;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (c != null) {
                c.disconnect();
            }
        }
    }

    private byte[] toPostData(Object data) {
        Gson gson = new GsonBuilder().create();
        String postData = data instanceof Map ? gson.toJson(data, new TypeToken<Map<String, Object>>(){}.getType()) : gson.toJson(data);
        try {
            return postData.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String appendQueryParams(String url, Map<String, Object> params) {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        Iterator<Map.Entry<String, Object>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Object entryVal;
            Map.Entry<String, Object> entry;
            pairs.add(new BasicNameValuePair(entry.getKey(), (entryVal = (entry = iterator.next()).getValue()) == null ? null : entryVal.toString()));
        }
        return url + "?" + URLEncodedUtils.format(pairs, (String)"UTF-8");
    }

    private static interface ResponseProcessor<R> {
        public R process(Reader var1);
    }
}

