/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form.validation;

import java.util.List;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.form.DataQueryGroupForm;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.datacleansing.manager.DataQueryGroupManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.collection.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class DataQueryGroupValidator
extends SimpleValidator<DataQueryGroupForm> {
    private static final String TITLE_FIELD = "title";
    private static final String QUERY_IDS_FIELD = "queryIds";
    @Autowired
    private DataQueryGroupManager dataQueryGroupManager;

    @Override
    public void validateForm(DataQueryGroupForm target, Errors errors) {
        if (this.validateRequiredField(errors, TITLE_FIELD)) {
            this.validateTitleUniqueness(target, errors);
        }
        if (this.validateRequiredField(errors, QUERY_IDS_FIELD)) {
            this.validateQueryUniqueness(target, errors);
        }
    }

    private boolean validateQueryUniqueness(DataQueryGroupForm target, Errors errors) {
        CollectSurvey survey = this.getActiveSurvey();
        List items = this.dataQueryGroupManager.loadBySurvey(survey);
        for (DataQueryGroup item : items) {
            List<DataQuery> queries;
            List queryIds;
            if (((Integer)item.getId()).equals(target.getId()) || !(queryIds = CollectionUtils.project(queries = item.getQueries(), (String)"id")).equals(target.getQueryIds())) continue;
            this.rejectDuplicateValue(errors, QUERY_IDS_FIELD, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateTitleUniqueness(DataQueryGroupForm target, Errors errors) {
        String title = target.getTitle();
        CollectSurvey survey = this.getActiveSurvey();
        List items = this.dataQueryGroupManager.loadBySurvey(survey);
        for (DataQueryGroup item : items) {
            if (((Integer)item.getId()).equals(target.getId()) || !item.getTitle().equalsIgnoreCase(title)) continue;
            this.rejectDuplicateValue(errors, TITLE_FIELD, new Object[0]);
            return false;
        }
        return true;
    }
}

