/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.commons.lang.Objects;

public abstract class FormObjects {
    public static <T, F extends FormObject<T>> List<F> fromObjects(List<T> objects, Class<F> formObjectType) {
        return FormObjects.fromObjects(objects, formObjectType, null);
    }

    public static <T, F extends FormObject<T>> List<F> fromObjects(List<T> objects, Class<F> formObjectType, String language) {
        ArrayList<FormObject> formObjects = new ArrayList<FormObject>(objects.size());
        for (T obj : objects) {
            FormObject formObject = (FormObject)Objects.newInstance(formObjectType, (Object[])new Object[0]);
            formObject.loadFrom(obj, language);
            formObjects.add(formObject);
        }
        return formObjects;
    }

    public static <T, F extends FormObject<T>> List<T> toObjects(List<F> formObjects, Class<T> objectType) {
        return FormObjects.toObjects(formObjects, objectType, null);
    }

    public static <T, F extends FormObject<T>> List<T> toObjects(List<F> formObjects, Class<T> objectType, String language) {
        ArrayList<Object> objects = new ArrayList<Object>(formObjects.size());
        for (FormObject formObject : formObjects) {
            Object obj = Objects.newInstance(objectType, (Object[])new Object[0]);
            formObject.saveTo(obj, language);
            objects.add(obj);
        }
        return objects;
    }
}

