/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.openforis.collect.designer.form.validator.NodeDefinitionFormValidator;
import org.openforis.collect.designer.viewmodel.AttributeVM;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefault;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.validation.Check;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class AttributeDefinitionFormValidator
extends NodeDefinitionFormValidator {
    protected static final String KEY_ATTRIBUTE_CANNOT_BE_MULTIPLE_MESSAGE_KEY = "survey.validation.attribute.key_attribute_cannot_be_multiple";
    private static final String KEY_CALCULATED_ATTRIBUTE_CAN_BE_ONLY_ONE_TIME_MESSAGE_KEY = "survey.validation.attribute.key_calculated_attribute_can_be_only_one_time";
    private static final String REFERENCED_ATTRIBUTE_DELETED_MESSAGE_KEY = "survey.validation.attribute.referenced_attribute_deleted";
    protected static final String CALCULATED_ONLY_ONE_TIME_FIELD = "calculatedOnlyOneTime";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        super.internalValidate(ctx);
        this.validateChecks(ctx);
        this.validateAttributeDefaults(ctx);
        this.validateMultipleAndKey(ctx);
        this.validateKeyAndCalculated(ctx);
        this.validateReferencedAttribute(ctx);
    }

    private void validateMultipleAndKey(ValidationContext ctx) {
        Boolean multiple = (Boolean)this.getValue(ctx, "multiple");
        Boolean key = (Boolean)this.getValue(ctx, "key", false);
        if (key != null && key.booleanValue() && multiple.booleanValue()) {
            this.addInvalidMessage(ctx, "key", Labels.getLabel((String)KEY_ATTRIBUTE_CANNOT_BE_MULTIPLE_MESSAGE_KEY));
            this.addInvalidMessage(ctx, "multiple", Labels.getLabel((String)KEY_ATTRIBUTE_CANNOT_BE_MULTIPLE_MESSAGE_KEY));
        }
    }

    private void validateKeyAndCalculated(ValidationContext ctx) {
        boolean key = this.getValueWithDefault(ctx, "key", false);
        boolean calculated = this.getValueWithDefault(ctx, "calculated", false);
        boolean calculatedOnlyOneTime = this.getValueWithDefault(ctx, CALCULATED_ONLY_ONE_TIME_FIELD, false);
        if (key && calculated && !calculatedOnlyOneTime) {
            this.addInvalidMessage(ctx, CALCULATED_ONLY_ONE_TIME_FIELD, Labels.getLabel((String)KEY_CALCULATED_ATTRIBUTE_CAN_BE_ONLY_ONE_TIME_MESSAGE_KEY));
        }
    }

    protected void validateAttributeDefaults(ValidationContext ctx) {
        boolean calculated = this.isCalculated(ctx);
        if (calculated) {
            AttributeVM vm = (AttributeVM)this.getVM(ctx);
            List<AttributeDefault> attributeDefaults = vm.getAttributeDefaults();
            this.validateRequired(ctx, "attributeDefaults", attributeDefaults);
        }
    }

    protected void validateChecks(ValidationContext ctx) {
        AttributeVM vm;
        List<Check<?>> checks;
        boolean calculated = this.isCalculated(ctx);
        if (calculated && (checks = (vm = (AttributeVM)this.getVM(ctx)).getChecks()) != null && !checks.isEmpty()) {
            this.addInvalidMessage(ctx, "checks", "survey.validation.attribute.cannot_specify_checks_for_calculated_attribute");
        }
    }

    private Boolean isCalculated(ValidationContext ctx) {
        return this.getValueWithDefault(ctx, "calculated", false);
    }

    @Override
    protected Set<String> getFieldNames(ValidationContext ctx) {
        HashSet<String> result = new HashSet<String>(super.getFieldNames(ctx));
        result.add("attributeDefaults");
        result.add("checks");
        return result;
    }

    private void validateReferencedAttribute(ValidationContext ctx) {
        String referencedAttributePath = (String)this.getValue(ctx, "referencedAttributePath", false);
        if (StringUtils.isNotBlank((String)referencedAttributePath)) {
            AttributeDefinition attrDef = (AttributeDefinition)this.getEditedNode(ctx);
            CollectSurvey survey = (CollectSurvey)attrDef.getSurvey();
            AttributeDefinition referencedAttribute = (AttributeDefinition)survey.getSchema().getDefinitionByPath(referencedAttributePath);
            if (referencedAttribute == null) {
                this.addInvalidMessage(ctx, "referencedAttributePath", Labels.getLabel((String)REFERENCED_ATTRIBUTE_DELETED_MESSAGE_KEY));
            } else {
                SurveyValidator.SurveyValidationResult validationResult = new SurveyValidator().validateReferencedKeyAttribute(attrDef, referencedAttribute);
                if (validationResult.getFlag() == SurveyValidator.SurveyValidationResult.Flag.ERROR) {
                    this.addInvalidMessage(ctx, "referencedAttributePath", Labels.getLabel((String)validationResult.getMessageKey(), (Object[])validationResult.getMessageArgs()));
                }
            }
        }
    }
}

