/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.HashMap;
import org.openforis.collect.designer.viewmodel.CodeListsVM;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.idm.metamodel.CodeList;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class CodeListsPopUpVM
extends SurveyBaseVM {
    public static final String EDITING_ATTRIBUTE_PARAM = "editingAttribute";
    public static final String SELECTED_CODE_LIST_PARAM = "selectedCodeList";
    public static final String CLOSE_CODE_LIST_ITEM_POP_UP_COMMAND = "closeCodeListItemPopUp";
    public static final String CLOSE_CODE_LIST_IMPORT_POP_UP_COMMAND = "closeCodeListImportPopUp";
    private boolean editingAttribute;
    @WireVariable
    private SurveyManager surveyManager;
    @WireVariable
    private CodeListManager codeListManager;

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="editingAttribute") Boolean editingAttribute, @ExecutionArgParam(value="selectedCodeList") CodeList selectedCodeList) {
        super.init();
        this.editingAttribute = editingAttribute != null && editingAttribute != false;
    }

    @Command
    public void apply(final @ContextParam(value=ContextType.VIEW) Component view, final @ContextParam(value=ContextType.BINDER) Binder binder) {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                if (confirmed) {
                    CodeListsPopUpVM.this.undoLastChanges(view);
                }
                CodeListsPopUpVM.this.postCodeListsManagerPopUpCommand(CodeListsPopUpVM.this.getSelectedCodeList(binder));
            }
        });
    }

    @Command
    public void close(@ContextParam(value=ContextType.TRIGGER_EVENT) Event event) {
        event.stopPropagation();
        this.dispatchCurrentFormValidatedCommand();
        this.postCodeListsManagerPopUpCommand(null);
    }

    private void postCodeListsManagerPopUpCommand(CodeList selectedCodeList) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(EDITING_ATTRIBUTE_PARAM, this.editingAttribute);
        params.put(SELECTED_CODE_LIST_PARAM, (Boolean)selectedCodeList);
        BindUtils.postGlobalCommand((String)null, (String)null, (String)"closeCodeListsManagerPopUp", params);
    }

    private CodeList getSelectedCodeList(Binder binder) {
        Component view = binder.getView();
        IdSpace spaceOwner = view.getSpaceOwner();
        Component innerInclude = spaceOwner.getFellow("codeListsInclude");
        Component managerContainer = innerInclude.getSpaceOwner().getFellow("codeListsManagerContainer");
        CodeListsVM vm = (CodeListsVM)managerContainer.getAttribute("vm");
        CodeList codeList = (CodeList)vm.getSelectedItem();
        return codeList;
    }
}

