/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.manager.MessageSource;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.RecordValidationReportGenerator;
import org.openforis.collect.model.RecordValidationReportItem;
import org.openforis.collect.model.validation.ValidationMessageBuilder;
import org.openforis.commons.collection.Visitor;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.validation.ValidationResultFlag;
import org.openforis.idm.path.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class ValidationReportJob
extends Job {
    private static final String[] VALIDATION_REPORT_HEADERS = new String[]{"Record", "Phase", "Attribute Schema Path", "Field path", "Field path (labels)", "Error message", "Severity"};
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private MessageSource messageSource;
    private Input input;
    private ValidationMessageBuilder validationMessageBuilder;
    private CsvWriter csvWriter;
    private OutputStream outputStream;
    private File outputFile;

    @Transactional(rollbackFor={RuntimeException.class})
    public synchronized void run() {
        super.run();
        if (!this.isCompleted()) {
            throw new RuntimeException("Error validating records");
        }
    }

    protected void initializeInternalVariables() throws Throwable {
        super.initializeInternalVariables();
        this.validationMessageBuilder = ValidationMessageBuilder.createInstance((MessageSource)this.messageSource);
        this.outputFile = File.createTempFile("of_collect_validation_report", ".csv");
        this.outputStream = new FileOutputStream(this.outputFile);
        if (this.input.reportType == ReportType.CSV) {
            this.csvWriter = new CsvWriter(this.outputStream, "UTF-8", ',', '\"');
        }
    }

    protected void buildTasks() throws Throwable {
        ValidationReportTask task = new ValidationReportTask();
        this.addTask((Worker)task);
    }

    protected void onEnd() {
        super.onEnd();
        if (this.input.reportType == ReportType.CSV) {
            IOUtils.closeQuietly((Closeable)this.csvWriter);
        }
    }

    public Input getInput() {
        return this.input;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    private class ValidationReportTask
    extends Task {
        private ValidationReportTask() {
        }

        protected long countTotalItems() {
            return ValidationReportJob.this.recordManager.countRecords(ValidationReportJob.this.input.recordFilter);
        }

        protected void execute() throws Throwable {
            this.writeHeader();
            ValidationReportJob.this.recordManager.visitSummaries(ValidationReportJob.this.input.recordFilter, null, (Visitor)new Visitor<CollectRecordSummary>(){

                public void visit(CollectRecordSummary summary) {
                    if (ValidationReportTask.this.isRunning()) {
                        try {
                            ValidationReportTask.this.writeValidationReport(summary);
                            ValidationReportTask.this.incrementProcessedItems();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }

        protected void writeValidationReport(CollectRecordSummary summary) throws IOException {
            CollectRecord.Step step = summary.getStep();
            Integer recordId = summary.getId();
            CollectRecord record = ValidationReportJob.this.recordManager.load(summary.getSurvey(), recordId.intValue(), step);
            ValidationReportJob.this.recordManager.validateAndSave(record);
            RecordValidationReportGenerator reportGenerator = new RecordValidationReportGenerator(record);
            Locale locale = ValidationReportJob.this.input.locale == null ? new Locale(record.getSurvey().getDefaultLanguage()) : ValidationReportJob.this.input.locale;
            List validationItems = reportGenerator.generateValidationItems(locale, ValidationResultFlag.WARNING, ValidationReportJob.this.input.includeConfirmedErrors);
            for (RecordValidationReportItem item : validationItems) {
                this.writeValidationReportLine(record, item);
            }
        }

        protected void writeHeader() throws IOException {
            if (ValidationReportJob.this.input.reportType == ReportType.CSV) {
                ValidationReportJob.this.csvWriter.writeHeaders(VALIDATION_REPORT_HEADERS);
            }
        }

        protected void writeValidationReportLine(CollectRecord record, RecordValidationReportItem item) {
            String recordKey = ValidationReportJob.this.validationMessageBuilder.getRecordKey(record);
            String phase = record.getStep().name();
            String absolutePath = Path.getAbsolutePath((String)item.getPath());
            NodeDefinition nodeDef = record.getSurvey().getSchema().getDefinitionByPath(absolutePath);
            Object[] line = new String[]{recordKey, phase, nodeDef.getPath(), item.getPath(), item.getPrettyFormatPath(), item.getMessage(), item.getSeverity().name().toLowerCase(Locale.ENGLISH)};
            if (ValidationReportJob.this.input.reportType == ReportType.CSV) {
                ValidationReportJob.this.csvWriter.writeNext(line);
            }
        }
    }

    public static class Input {
        private ReportType reportType = ReportType.CSV;
        private RecordFilter recordFilter;
        private boolean includeConfirmedErrors = true;
        private Locale locale = Locale.ENGLISH;

        public ReportType getReportType() {
            return this.reportType;
        }

        public void setReportType(ReportType reportType) {
            this.reportType = reportType;
        }

        public RecordFilter getRecordFilter() {
            return this.recordFilter;
        }

        public void setRecordFilter(RecordFilter recordFilter) {
            this.recordFilter = recordFilter;
        }

        public boolean isIncludeConfirmedErrors() {
            return this.includeConfirmedErrors;
        }

        public void setIncludeConfirmedErrors(boolean includeConfirmedErrors) {
            this.includeConfirmedErrors = includeConfirmedErrors;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }
    }

    public static enum ReportType {
        CSV;

    }
}

