/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.AttributeVM;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.Precision;
import org.openforis.idm.metamodel.Schema;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Window;

public class NumericAttributeVM
extends AttributeVM<NumericAttributeDefinition> {
    @WireVariable
    private SurveyManager surveyManager;
    protected List<Precision> precisions;
    protected Precision selectedPrecision;
    private boolean editingNewPrecision;
    private Precision editedPrecision;
    private Window precisionPopUp;

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="parentEntity") EntityDefinition parentEntity, @ExecutionArgParam(value="item") NumericAttributeDefinition attributeDefn, @ExecutionArgParam(value="newItem") Boolean newItem) {
        super.initInternal(parentEntity, attributeDefn, newItem);
    }

    @Override
    public void setEditedItem(NumericAttributeDefinition editedItem) {
        super.setEditedItem(editedItem);
        this.precisions = editedItem != null ? editedItem.getPrecisionDefinitions() : null;
    }

    @Command
    @NotifyChange(value={"precisions"})
    public void addPrecision() {
        this.editingNewPrecision = true;
        this.editedPrecision = new Precision();
        this.openPrecisionEditPopUp();
    }

    @Command
    public void editPrecision() {
        this.editingNewPrecision = false;
        this.editedPrecision = this.selectedPrecision;
        this.openPrecisionEditPopUp();
    }

    @Command
    @NotifyChange(value={"selectedPrecision", "precisions"})
    public void deletePrecision() {
        MessageUtil.ConfirmParams params = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                ((NumericAttributeDefinition)NumericAttributeVM.this.editedItem).removePrecisionDefinition(NumericAttributeVM.this.selectedPrecision);
                NumericAttributeVM.this.selectedPrecision = null;
                NumericAttributeVM.this.initPrecisions();
                NumericAttributeVM.this.notifyChange("selectedPrecision");
            }
        }, "survey.schema.attribute.numeric.precisions.confirm_delete");
        params.setOkLabelKey("global.delete_item");
        MessageUtil.showConfirm(params);
    }

    protected void openPrecisionEditPopUp() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("parentDefinition", this.editedItem);
        args.put("newItem", this.editingNewPrecision);
        args.put("precision", this.editedPrecision);
        this.precisionPopUp = NumericAttributeVM.openPopUp(Resources.Component.PRECISION_POPUP.getLocation(), true, args);
    }

    @Command
    @NotifyChange(value={"selectedPrecision"})
    public void selectPrecision(@BindingParam(value="precision") Precision precision) {
        this.selectedPrecision = precision;
    }

    @GlobalCommand
    public void closeUnitsManagerPopUp(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.validateForm(binder);
    }

    @GlobalCommand
    public void applyChangesToEditedPrecision(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (this.editedPrecision != null && this.checkCanLeaveForm()) {
            if (this.editedPrecision.isDefaultPrecision()) {
                this.removeDefaultAssignmentToPrecisions();
                this.editedPrecision.setDefaultPrecision(true);
            }
            this.closePrecisionEditPopUp(binder);
            this.editedPrecision = null;
            this.initPrecisions();
            this.notifyChange("editedPrecision");
        }
    }

    protected void removeDefaultAssignmentToPrecisions() {
        List precisionDefinitions = ((NumericAttributeDefinition)this.editedItem).getPrecisionDefinitions();
        for (Precision precision : precisionDefinitions) {
            precision.setDefaultPrecision(false);
        }
    }

    @GlobalCommand
    public void cancelChangesToEditedPrecision(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (this.editedPrecision != null) {
            this.closePrecisionEditPopUp(binder);
            this.editedPrecision = null;
            this.notifyChange("editedPrecision");
        }
    }

    protected void closePrecisionEditPopUp(Binder binder) {
        NumericAttributeVM.closePopUp(this.precisionPopUp);
        this.precisionPopUp = null;
        this.validateForm(binder);
    }

    protected void initPrecisions() {
        this.precisions = this.editedItem != null ? new ArrayList<Precision>(((NumericAttributeDefinition)this.editedItem).getPrecisionDefinitions()) : null;
        this.notifyChange("precisions");
    }

    @Command
    @NotifyChange(value={"precisions"})
    public void moveSelectedPrecisionUp() {
        this.moveSelectedPrecision(true);
    }

    @Command
    @NotifyChange(value={"precisions"})
    public void moveSelectedPrecisionDown() {
        this.moveSelectedPrecision(false);
    }

    protected void moveSelectedPrecision(boolean up) {
        int indexFrom = this.getSelectedPrecisionIndex();
        int indexTo = up ? indexFrom - 1 : indexFrom + 1;
        this.moveSelectedPrecision(indexTo);
        this.initPrecisions();
    }

    protected int getSelectedPrecisionIndex() {
        List items = ((NumericAttributeDefinition)this.editedItem).getPrecisionDefinitions();
        int index = items.indexOf(this.selectedPrecision);
        return index;
    }

    protected void moveSelectedPrecision(int indexTo) {
        ((NumericAttributeDefinition)this.editedItem).movePrecisionDefinition(this.selectedPrecision, indexTo);
        this.initPrecisions();
    }

    public boolean isTypeChangeDisabled() {
        NodeDefinition oldNodeDefn = this.getOldNodeDefinition();
        return oldNodeDefn != null;
    }

    protected NodeDefinition getOldNodeDefinition() {
        SessionStatus sessionStatus = this.getSessionStatus();
        Integer publishedSurveyId = sessionStatus.getPublishedSurveyId();
        if (publishedSurveyId != null) {
            CollectSurvey publishedSurvey = this.surveyManager.getById(publishedSurveyId.intValue());
            Schema schema = publishedSurvey.getSchema();
            int nodeId = ((NumericAttributeDefinition)this.editedItem).getId();
            NodeDefinition oldDefn = schema.getDefinitionById(nodeId);
            return oldDefn;
        }
        return null;
    }

    @DependsOn(value={"precisions", "selectedPrecision"})
    public boolean isMoveSelectedPrecisionUpDisabled() {
        return this.isMoveSelectedPrecisionDisabled(true);
    }

    @DependsOn(value={"precisions", "selectedPrecision"})
    public boolean isMoveSelectedPrecisionDownDisabled() {
        return this.isMoveSelectedPrecisionDisabled(false);
    }

    protected boolean isMoveSelectedPrecisionDisabled(boolean up) {
        if (this.selectedPrecision == null) {
            return true;
        }
        List siblings = ((NumericAttributeDefinition)this.editedItem).getPrecisionDefinitions();
        int index = siblings.indexOf(this.selectedPrecision);
        return up ? index <= 0 : index < 0 || index >= siblings.size() - 1;
    }

    public List<Precision> getPrecisions() {
        return this.precisions;
    }

    public Precision getSelectedPrecision() {
        return this.selectedPrecision;
    }

    public void setSelectedPrecision(Precision selectedPrecision) {
        this.selectedPrecision = selectedPrecision;
    }
}

