/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.Closeable;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.metamodel.NodeType;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Predicate;
import org.openforis.collect.designer.viewmodel.BaseSurveyFileImportVM;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.SchemaObjectSelectorPopUpVM;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.SurveyObjects;
import org.openforis.commons.io.csv.CsvLine;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.AttributeType;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.SurveyObject;
import org.openforis.idm.metamodel.TextAttributeDefinition;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public class SchemaAttributesImportVM
extends BaseSurveyFileImportVM {
    private EntityDefinition parentEntityDefinition;
    private boolean booleanAsCode;
    private boolean labelsInSecondRow;

    public SchemaAttributesImportVM() {
        super(new String[]{"csv", "xlsx"}, null);
        this.reset();
    }

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
        this.parentEntityDefinition = this.survey.getSchema().getFirstRootEntityDefinition();
        this.notifyChange("parentEntityDefinitionPath");
    }

    @Command
    public void importAttributes(@ContextParam(value=ContextType.BIND_CONTEXT) BindContext ctx) {
        if (this.validateForm(ctx)) {
            Map<String, AttributeDetails> attributeDetailsByColumn = new AttributeDetailsExtractor(this.uploadedFile, this.labelsInSecondRow).extractAttributeDetailsByColumn();
            List<AttributeDefinition> newAttributes = new AttributesImporter(this.parentEntityDefinition, this.booleanAsCode).importAttributes(attributeDetailsByColumn);
            MessageUtil.showInfo("survey.schema.attributes_import.import_complete", newAttributes.size(), attributeDetailsByColumn.size() - newAttributes.size());
            this.dispatchSchemaChangedCommand();
        }
    }

    @Command
    public void openParentEntitySelectionButton() {
        Predicate<SurveyObject> includedNodePredicate = new Predicate<SurveyObject>(){

            @Override
            public boolean evaluate(SurveyObject item) {
                return item instanceof UITab || item instanceof EntityDefinition;
            }
        };
        Predicate<SurveyObject> selectableNodePredicate = new Predicate<SurveyObject>(){

            @Override
            public boolean evaluate(SurveyObject item) {
                return item instanceof EntityDefinition;
            }
        };
        String title = Labels.getLabel((String)"survey.schema.attributes_import.select_entity.popup.title");
        final Window popup = SchemaObjectSelectorPopUpVM.openPopup(title, false, this.parentEntityDefinition.getRootEntity(), null, includedNodePredicate, true, true, null, selectableNodePredicate, (SurveyObject)this.parentEntityDefinition, false);
        popup.addEventListener("onNodeSelected", (EventListener)new EventListener<SchemaObjectSelectorPopUpVM.NodeSelectedEvent>(){

            public void onEvent(SchemaObjectSelectorPopUpVM.NodeSelectedEvent event) throws Exception {
                SurveyObject selectedParent = event.getSelectedItem();
                SchemaAttributesImportVM.this.parentEntityDefinition = (EntityDefinition)selectedParent;
                SchemaAttributesImportVM.this.notifyChange("parentEntityDefinitionPath");
                BaseVM.closePopUp(popup);
            }
        });
    }

    public String getParentEntityDefinitionPath() {
        return this.parentEntityDefinition == null ? null : this.parentEntityDefinition.getPath();
    }

    public boolean isBooleanAsCode() {
        return this.booleanAsCode;
    }

    public void setBooleanAsCode(boolean booleanAsCode) {
        this.booleanAsCode = booleanAsCode;
    }

    public boolean isLabelsInSecondRow() {
        return this.labelsInSecondRow;
    }

    public void setLabelsInSecondRow(boolean labelsInSecondRow) {
        this.labelsInSecondRow = labelsInSecondRow;
    }

    private static class AttributeDetailsExtractor {
        private static final AttributeType DEFAULT_ATTRIBUTE_TYPE = AttributeType.TEXT;
        private static final String[] BOOLEAN_VALUES = new String[]{"true", "false", "yes", "no"};
        private File file;
        private boolean labelsInSecondRow = false;

        public AttributeDetailsExtractor(File file, boolean labelsInSecondRow) {
            this.file = file;
            this.labelsInSecondRow = labelsInSecondRow;
        }

        public Map<String, AttributeDetails> extractAttributeDetailsByColumn() {
            Map<String, AttributeType> attributeTypeByColumn = this.guessAttributeTypeByColumn();
            LinkedHashMap<String, AttributeDetails> result = new LinkedHashMap<String, AttributeDetails>(attributeTypeByColumn.size());
            Map<String, String> labelByColumn = this.labelsInSecondRow ? this.extractLabelByColumn() : null;
            for (Map.Entry<String, AttributeType> entry : attributeTypeByColumn.entrySet()) {
                AttributeDetails details = new AttributeDetails();
                String colName = entry.getKey();
                AttributeType type = entry.getValue();
                details.setType(type == null ? DEFAULT_ATTRIBUTE_TYPE : type);
                if (this.labelsInSecondRow) {
                    details.setLabel(labelByColumn.get(colName));
                }
                result.put(colName, details);
            }
            return result;
        }

        private Map<String, String> extractLabelByColumn() {
            LinkedHashMap<String, String> linkedHashMap;
            CsvReader reader = null;
            try {
                reader = new CsvReader(this.file);
                reader.readHeaders();
                List columnNames = reader.getColumnNames();
                CsvLine labelsLine = reader.readNextLine();
                LinkedHashMap<String, String> labelByColumn = new LinkedHashMap<String, String>(columnNames.size());
                String[] labels = labelsLine.getLine();
                for (int i = 0; i < labels.length; ++i) {
                    String colName = (String)columnNames.get(i);
                    String label = labels[i];
                    labelByColumn.put(colName, label);
                }
                linkedHashMap = labelByColumn;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
            return linkedHashMap;
        }

        private Map<String, AttributeType> guessAttributeTypeByColumn() {
            LinkedHashMap<String, AttributeType> linkedHashMap;
            CsvReader reader = null;
            try {
                reader = new CsvReader(this.file);
                reader.readHeaders();
                List columnNames = reader.getColumnNames();
                LinkedHashMap<String, AttributeType> typeByColumn = new LinkedHashMap<String, AttributeType>(columnNames.size());
                for (String colName : columnNames) {
                    typeByColumn.put(colName, null);
                }
                CsvLine line = reader.readNextLine();
                if (this.labelsInSecondRow) {
                    line = reader.readNextLine();
                }
                while (line != null && reader.getLinesRead() <= 100L) {
                    String[] values = line.getLine();
                    for (int i = 0; i < columnNames.size(); ++i) {
                        String colName;
                        AttributeType currentAttributeType;
                        String val = values[i];
                        if (!StringUtils.isNotBlank((CharSequence)val) || (currentAttributeType = (AttributeType)typeByColumn.get(colName = (String)columnNames.get(i))) != null && currentAttributeType == DEFAULT_ATTRIBUTE_TYPE) continue;
                        AttributeType attributeType = this.isDate(reader, val) ? AttributeType.DATE : (NumberUtils.isNumber((String)val) ? AttributeType.NUMBER : (AttributeDetailsExtractor.isBoolean(reader, val) ? AttributeType.BOOLEAN : DEFAULT_ATTRIBUTE_TYPE));
                        if (currentAttributeType == null) {
                            typeByColumn.put(colName, attributeType);
                            continue;
                        }
                        if (attributeType != DEFAULT_ATTRIBUTE_TYPE || currentAttributeType == attributeType) continue;
                        typeByColumn.put(colName, DEFAULT_ATTRIBUTE_TYPE);
                    }
                    line = reader.readNextLine();
                }
                for (String colName : columnNames) {
                    if (typeByColumn.get(colName) != null) continue;
                    typeByColumn.put(colName, DEFAULT_ATTRIBUTE_TYPE);
                }
                linkedHashMap = typeByColumn;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
            return linkedHashMap;
        }

        private boolean isDate(CsvReader reader, String val) {
            try {
                return reader.getDateFormat().parse(val) != null;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public static boolean isBoolean(CsvReader reader, String val) {
            return ArrayUtils.contains((Object[])BOOLEAN_VALUES, (Object)val.toLowerCase(Locale.ENGLISH));
        }
    }

    private static class AttributesImporter {
        private static final String YES_NO_LIST_NAME = "yes_no";
        private EntityDefinition parentEntityDefinition;
        private boolean booleanAttributeAsCode = false;

        public AttributesImporter(EntityDefinition parentEntityDefinition, boolean booleanAttributeAsCode) {
            this.parentEntityDefinition = parentEntityDefinition;
            this.booleanAttributeAsCode = booleanAttributeAsCode;
        }

        public List<AttributeDefinition> importAttributes(Map<String, AttributeDetails> attributeDetailsByColumn) {
            ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
            CollectSurvey survey = (CollectSurvey)this.parentEntityDefinition.getSurvey();
            for (Map.Entry<String, AttributeDetails> entry : attributeDetailsByColumn.entrySet()) {
                String attributeName;
                AttributeType type;
                String colName = entry.getKey();
                AttributeDetails details = entry.getValue();
                CodeList codeList = null;
                AttributeType foundType = details.getType();
                if (foundType == AttributeType.BOOLEAN && this.booleanAttributeAsCode) {
                    type = AttributeType.CODE;
                    codeList = this.getOrCreateYesNoList(survey);
                } else {
                    type = foundType;
                }
                AttributeDefinition attrDef = (AttributeDefinition)NodeType.createNodeDefinition((Survey)survey, NodeType.ATTRIBUTE, type);
                switch (type) {
                    case CODE: {
                        ((CodeAttributeDefinition)attrDef).setList(codeList);
                        break;
                    }
                    case TEXT: {
                        ((TextAttributeDefinition)attrDef).setType(TextAttributeDefinition.Type.SHORT);
                        break;
                    }
                }
                if (this.parentEntityDefinition.containsChildDefinition(attributeName = SurveyObjects.adjustInternalName((String)colName))) continue;
                attrDef.setName(attributeName);
                String label = details.getLabel();
                if (StringUtils.isNotBlank((CharSequence)label)) {
                    attrDef.setLabel(NodeLabel.Type.INSTANCE, survey.getDefaultLanguage(), label);
                }
                this.parentEntityDefinition.addChildDefinition((NodeDefinition)attrDef);
                result.add(attrDef);
            }
            return result;
        }

        private CodeList getOrCreateYesNoList(CollectSurvey survey) {
            CodeList list = survey.getCodeList(YES_NO_LIST_NAME);
            if (list == null) {
                list = survey.createCodeList();
                list.setName(YES_NO_LIST_NAME);
                CodeListItem item = list.createItem(1);
                item.setCode("yes");
                item.setLabel(survey.getDefaultLanguage(), "Yes");
                list.addItem(item);
                item = list.createItem(1);
                item.setCode("no");
                item.setLabel(survey.getDefaultLanguage(), "No");
                list.addItem(item);
                survey.addCodeList(list);
            }
            return list;
        }
    }

    private static class AttributeDetails {
        private AttributeType type;
        private String label;

        private AttributeDetails() {
        }

        public AttributeType getType() {
            return this.type;
        }

        public void setType(AttributeType type) {
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

