/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.view;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.uiconfiguration.view.Views;
import org.openforis.collect.metamodel.view.AttributeDefView;
import org.openforis.collect.metamodel.view.BooleanAttributeDefView;
import org.openforis.collect.metamodel.view.CodeAttributeDefView;
import org.openforis.collect.metamodel.view.CodeListItemView;
import org.openforis.collect.metamodel.view.CodeListView;
import org.openforis.collect.metamodel.view.CoordinateAttributeDefView;
import org.openforis.collect.metamodel.view.EntityDefView;
import org.openforis.collect.metamodel.view.FileAttributeDefView;
import org.openforis.collect.metamodel.view.ModelVersionView;
import org.openforis.collect.metamodel.view.NodeDefView;
import org.openforis.collect.metamodel.view.NumberAttributeDefView;
import org.openforis.collect.metamodel.view.NumericAttributeDefView;
import org.openforis.collect.metamodel.view.PrecisionView;
import org.openforis.collect.metamodel.view.RangeAttributeDefView;
import org.openforis.collect.metamodel.view.SpatialReferenceSystemView;
import org.openforis.collect.metamodel.view.SurveyView;
import org.openforis.collect.metamodel.view.TaxonAttributeDefView;
import org.openforis.collect.metamodel.view.TextAttributeDefView;
import org.openforis.collect.metamodel.view.UnitView;
import org.openforis.collect.metamodel.view.ViewContext;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.collect.utils.Dates;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.commons.collection.Predicate;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.AttributeType;
import org.openforis.idm.metamodel.BooleanAttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLabel;
import org.openforis.idm.metamodel.CodeListService;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.FileAttributeDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.Precision;
import org.openforis.idm.metamodel.SpatialReferenceSystem;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.openforis.idm.metamodel.TextAttributeDefinition;
import org.openforis.idm.metamodel.Unit;

public class SurveyViewGenerator {
    private boolean includeCodeListValues = false;
    private String languageCode;

    public SurveyViewGenerator(String languageCode) {
        this.languageCode = languageCode;
    }

    public List<SurveyView> generateViews(List<CollectSurvey> surveys) {
        ArrayList<SurveyView> result = new ArrayList<SurveyView>();
        for (CollectSurvey s : surveys) {
            result.add(this.generateView(s));
        }
        return result;
    }

    public SurveyView generateView(CollectSurvey survey) {
        return this.generateView(survey, null, null);
    }

    public SurveyView generateView(CollectSurvey survey, UserGroup userGroup, UserInGroup.UserGroupRole userInSurveyGroupRole) {
        String defaultLanguage = survey.getDefaultLanguage();
        final UIOptions uiOptions = survey.getUIOptions();
        final SurveyView surveyView = new SurveyView(survey, new ViewContext(this.languageCode));
        if (userGroup != null) {
            surveyView.setUserGroupQualifierName(userGroup.getQualifierName());
            surveyView.setUserGroupQualifierValue(userGroup.getQualifierValue());
            surveyView.setUserInGroupRole(userInSurveyGroupRole);
        }
        for (CodeList codeList : survey.getCodeLists()) {
            CodeListView codeListView = new CodeListView();
            codeListView.setId(codeList.getId());
            codeListView.setName(codeList.getName());
            codeListView.setLabel(codeList.getLabel(CodeListLabel.Type.ITEM, this.languageCode));
            if (this.includeCodeListValues && !codeList.isExternal()) {
                CodeListService service = survey.getContext().getCodeListService();
                List items = service.loadRootItems(codeList);
                for (CodeListItem item : items) {
                    codeListView.addItem(this.createCodeListItemView(item));
                }
            }
            surveyView.addCodeList(codeListView);
        }
        for (ModelVersion version : survey.getVersions()) {
            ModelVersionView versionView = new ModelVersionView();
            versionView.setId(version.getId());
            versionView.setName(version.getName());
            versionView.setLabel(version.getLabel(this.languageCode));
            versionView.setDate(Dates.formatDate((Date)version.getDate()));
            surveyView.addModelVersion(versionView);
        }
        for (Unit unit : survey.getUnits()) {
            UnitView unitView = new UnitView();
            unitView.setId(unit.getId());
            unitView.setConversionFactor(unit.getConversionFactor());
            unitView.setAbbreviation(unit.getAbbreviation(this.languageCode, defaultLanguage));
            unitView.setLabel(unit.getLabel(this.languageCode, defaultLanguage));
            surveyView.addUnit(unitView);
        }
        for (SpatialReferenceSystem srs : survey.getSpatialReferenceSystems()) {
            SpatialReferenceSystemView srsView = new SpatialReferenceSystemView();
            srsView.setId(srs.getId());
            srsView.setLabel(srs.getLabel(this.languageCode, defaultLanguage));
            srsView.setDescription(srs.getDescription(this.languageCode, defaultLanguage));
            surveyView.addSpatialReferenceSystem(srsView);
        }
        final HashMap viewById = new HashMap();
        survey.getSchema().traverse(new NodeDefinitionVisitor(){

            public void visit(NodeDefinition def) {
                NodeDefView view;
                int id = def.getId();
                String name = def.getName();
                String label = def.getLabel(NodeLabel.Type.INSTANCE, SurveyViewGenerator.this.languageCode);
                boolean multiple = def.isMultiple();
                if (def instanceof EntityDefinition) {
                    EntityDefinition entityDefinition = (EntityDefinition)def;
                    EntityDefView entityDefView = new EntityDefView(entityDefinition.isRoot(), id, name, label, multiple);
                    entityDefView.setEnumerate(entityDefinition.isEnumerate() && entityDefinition.isEnumerable());
                    view = entityDefView;
                } else {
                    view = SurveyViewGenerator.this.createAttributeDefView((AttributeDefinition)def);
                }
                view.setDescription(def.getDescription(SurveyViewGenerator.this.languageCode));
                view.setNumberLabel(def.getLabel(NodeLabel.Type.NUMBER, SurveyViewGenerator.this.languageCode));
                view.setHeadingLabel(def.getLabel(NodeLabel.Type.HEADING, SurveyViewGenerator.this.languageCode));
                view.setSinceVersionId(def.getSinceVersionId());
                view.setDeprecatedVersionId(def.getDeprecatedVersionId());
                view.setAlwaysRelevant(def.isAlwaysRelevant());
                view.setHideWhenNotRelevant(uiOptions.isHideWhenNotRelevant(def));
                view.setLabelWidth(uiOptions.getLabelWidth(def));
                view.setWidth(uiOptions.getWidth(def));
                NodeDefinition parentDef = def.getParentDefinition();
                if (parentDef == null) {
                    surveyView.getSchema().addRootEntity((EntityDefView)view);
                } else {
                    EntityDefView parentView = (EntityDefView)viewById.get(parentDef.getId());
                    parentView.addChild(view);
                }
                viewById.put(id, view);
            }
        });
        return surveyView;
    }

    private CodeListItemView createCodeListItemView(CodeListItem item) {
        CodeListService service = item.getSurvey().getContext().getCodeListService();
        CodeListItemView itemView = new CodeListItemView();
        itemView.id = item.getId();
        itemView.code = item.getCode();
        itemView.label = item.getLabel(this.languageCode);
        itemView.description = item.getDescription(this.languageCode);
        itemView.color = item.getColor();
        ArrayList<CodeListItemView> childItemsView = new ArrayList<CodeListItemView>();
        List childItems = service.loadChildItems(item);
        for (CodeListItem childItem : childItems) {
            childItemsView.add(this.createCodeListItemView(childItem));
        }
        itemView.items.addAll(childItemsView);
        return itemView;
    }

    private AttributeDefView createAttributeDefView(AttributeDefinition def) {
        AttributeDefView view;
        AttributeDefView attrDefView;
        CollectSurvey survey = (CollectSurvey)def.getSurvey();
        CollectAnnotations annotations = survey.getAnnotations();
        UIOptions uiOptions = survey.getUIOptions();
        int id = def.getId();
        String name = def.getName();
        String label = def.getLabel(NodeLabel.Type.INSTANCE, this.languageCode);
        boolean multiple = def.isMultiple();
        boolean qualifier = annotations.isQualifier(def);
        boolean showInSummary = annotations.isShowInSummary(def);
        AttributeType attributeType = AttributeType.valueOf((AttributeDefinition)def);
        List fieldNames = def.getFieldNames();
        boolean key = def.isKey();
        if (def instanceof BooleanAttributeDefinition) {
            BooleanAttributeDefinition booleanAttrDef = (BooleanAttributeDefinition)def;
            attrDefView = new BooleanAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
            ((BooleanAttributeDefView)attrDefView).setLayoutType(booleanAttrDef.isAffirmativeOnly() ? BooleanAttributeDefView.LayoutType.CHECKBOX : BooleanAttributeDefView.LayoutType.TEXTBOX);
            view = attrDefView;
        } else if (def instanceof CodeAttributeDefinition) {
            CodeAttributeDefinition codeAttrDef = (CodeAttributeDefinition)def;
            CodeList codeList = codeAttrDef.getList();
            int codeListId = codeList == null ? -1 : codeList.getId();
            CodeAttributeDefView attrDefView2 = new CodeAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
            attrDefView2.setCodeListId(codeListId);
            attrDefView2.setEnumerator(codeAttrDef.isEnumerator());
            Integer codeParentDefId = codeAttrDef.getParentCodeAttributeDefinition() == null ? null : Integer.valueOf(codeAttrDef.getParentCodeAttributeDefinition().getId());
            attrDefView2.setParentCodeAttributeDefinitionId(codeParentDefId);
            attrDefView2.setShowCode(uiOptions.getShowCode(codeAttrDef));
            attrDefView2.setLayout(uiOptions.getLayoutType(codeAttrDef));
            attrDefView2.setItemsOrientation(uiOptions.getLayoutDirection(codeAttrDef));
            attrDefView2.setHasQualifiableItems(codeList == null ? false : survey.getContext().getCodeListService().hasQualifiableItems(codeList));
            view = attrDefView2;
        } else if (def instanceof CoordinateAttributeDefinition) {
            CoordinateAttributeDefinition coordDef = (CoordinateAttributeDefinition)def;
            attrDefView = new CoordinateAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
            ((CoordinateAttributeDefView)attrDefView).setFieldsOrder(uiOptions.getFieldsOrder(coordDef));
            ((CoordinateAttributeDefView)attrDefView).setShowSrsField(annotations.isShowSrsField(coordDef));
            ((CoordinateAttributeDefView)attrDefView).setIncludeAccuracyField(annotations.isIncludeCoordinateAccuracy(coordDef));
            ((CoordinateAttributeDefView)attrDefView).setIncludeAltitudeField(annotations.isIncludeCoordinateAltitude(coordDef));
            view = attrDefView;
        } else if (def instanceof FileAttributeDefinition) {
            FileAttributeDefinition fileDef = (FileAttributeDefinition)def;
            attrDefView = new FileAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
            ((FileAttributeDefView)attrDefView).setFileType(annotations.getFileType(fileDef));
            ((FileAttributeDefView)attrDefView).setMaxSize(fileDef.getMaxSize());
            ((FileAttributeDefView)attrDefView).setExtensions(fileDef.getExtensions());
            view = attrDefView;
        } else if (def instanceof NumericAttributeDefinition) {
            NumericAttributeDefinition numericDef = (NumericAttributeDefinition)def;
            attrDefView = def instanceof NumberAttributeDefinition ? new NumberAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple) : new RangeAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
            ((NumericAttributeDefView)attrDefView).setNumericType(numericDef.getType());
            ArrayList precisions = new ArrayList(numericDef.getPrecisionDefinitions());
            CollectionUtils.filter(precisions, (Predicate)new Predicate<Precision>(){

                public boolean evaluate(Precision item) {
                    return item.getUnit() != null;
                }
            });
            List<PrecisionView> precisionViews = Views.fromObjects(precisions, PrecisionView.class);
            ((NumericAttributeDefView)attrDefView).setPrecisions(precisionViews);
            view = attrDefView;
        } else if (def instanceof TaxonAttributeDefinition) {
            TaxonAttributeDefinition taxonDef = (TaxonAttributeDefinition)def;
            attrDefView = new TaxonAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
            ((TaxonAttributeDefView)attrDefView).setTaxonomyName(taxonDef.getTaxonomy());
            ((TaxonAttributeDefView)attrDefView).setHighestRank(taxonDef.getHighestTaxonRank());
            ((TaxonAttributeDefView)attrDefView).setShowFamily(annotations.isShowFamily(taxonDef));
            ((TaxonAttributeDefView)attrDefView).setIncludeUniqueVernacularName(annotations.isIncludeUniqueVernacularName(taxonDef));
            ((TaxonAttributeDefView)attrDefView).setAllowUnlisted(annotations.isAllowUnlisted(taxonDef));
            view = attrDefView;
        } else if (def instanceof TextAttributeDefinition) {
            TextAttributeDefinition textDef = (TextAttributeDefinition)def;
            attrDefView = new TextAttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
            ((TextAttributeDefView)attrDefView).setTextType(textDef.getType());
            boolean autoUppercase = uiOptions.isAutoUppercase(textDef);
            TextAttributeDefView.TextTransform textTransform = autoUppercase ? TextAttributeDefView.TextTransform.UPPERCASE : TextAttributeDefView.TextTransform.NONE;
            ((TextAttributeDefView)attrDefView).setTextTransform(textTransform);
            ((TextAttributeDefView)attrDefView).setGeometry(annotations.isGeometry(textDef));
            view = attrDefView;
        } else {
            view = new AttributeDefView(id, name, label, attributeType, fieldNames, key, multiple);
        }
        view.setShowInRecordSummaryList(showInSummary);
        view.setQualifier(qualifier);
        List fieldLabels = def.getFieldLabels();
        HashMap<String, Boolean> visibilityByField = new HashMap<String, Boolean>();
        ArrayList<String> fieldLabelsView = new ArrayList<String>(fieldLabels.size());
        for (String fieldName : def.getFieldNames()) {
            fieldLabelsView.add(def.getFieldLabel(fieldName, this.languageCode));
            visibilityByField.put(fieldName, uiOptions.isVisibleField(def, fieldName));
        }
        view.setFieldLabels(fieldLabelsView);
        view.setVisibilityByField(visibilityByField);
        view.setCalculated(def.isCalculated());
        view.setHidden(uiOptions.isHidden((NodeDefinition)def));
        return view;
    }

    public void setIncludeCodeListValues(boolean includeCodeListValues) {
        this.includeCodeListValues = includeCodeListValues;
    }
}

