/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.model.LabelledItem;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.idm.metamodel.Languages;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class SurveyLanguageVM
extends BaseVM {
    public static final String CURRENT_LANGUAGE_CHANGED_COMMAND = "currentLanguageChanged";
    public static final String SURVEY_LANGUAGES_CHANGED_COMMAND = "surveyLanguagesChanged";
    public static final String CLOSE_SURVEY_LANGUAGE_SELECT_POPUP_COMMAND = "closeSurveyLanguageSelectPopUp";
    private static final int MAX_LANGUAGES = 5;
    @WireVariable
    private SurveyManager surveyManager;
    private List<LabelledItem> languages;
    private List<LabelledItem> assignedLanguages;
    private LabelledItem selectedAssignedLanguage;
    private LabelledItem selectedLanguageToAssign;

    @Override
    @Init
    public void init() {
        this.languages = new ArrayList<LabelledItem>();
        List codes = Languages.getCodes((Languages.Standard)Languages.Standard.ISO_639_1);
        for (String code : codes) {
            LabelledItem item = new LabelledItem(code, Labels.getLabel((String)code));
            this.languages.add(item);
        }
        Collections.sort(this.languages, new LabelledItem.LabelComparator());
        this.assignedLanguages = this.getSurveyAssignedLanguages();
    }

    protected List<String> getSurveyAssignedLanguageCodes() {
        SessionStatus sessionStatus = this.getSessionStatus();
        CollectSurvey survey = sessionStatus.getSurvey();
        if (survey == null) {
            return null;
        }
        return survey.getLanguages();
    }

    protected List<LabelledItem> getSurveyAssignedLanguages() {
        ArrayList<LabelledItem> result = new ArrayList<LabelledItem>();
        List<String> assignedLanguageCodes = this.getSurveyAssignedLanguageCodes();
        for (String code : assignedLanguageCodes) {
            for (LabelledItem item : this.languages) {
                if (!item.getCode().equals(code)) continue;
                result.add(item);
            }
        }
        return result;
    }

    public List<String> getSelectedLanguageCodes() {
        ArrayList<String> result = new ArrayList<String>();
        for (LabelledItem item : this.assignedLanguages) {
            result.add(item.getCode());
        }
        return result;
    }

    public List<LabelledItem> getLanguages() {
        return this.languages;
    }

    @Command
    @NotifyChange(value={"assignedLanguages", "selectedLanguageToAssign"})
    public void addLanguage() {
        if (this.assignedLanguages.size() == 5) {
            MessageUtil.showWarning("survey.language.error.maximum_number_of_languages_reached", 5);
            return;
        }
        this.assignedLanguages.add(this.selectedLanguageToAssign);
        this.selectedLanguageToAssign = null;
    }

    @Command
    @NotifyChange(value={"assignedLanguages", "selectedAssignedLanguage"})
    public void removeLanguage() {
        String defaultLangCode = this.getSurveyAssignedLanguageCodes().get(0);
        if (this.assignedLanguages.indexOf(this.selectedAssignedLanguage) != this.assignedLanguages.size() - 1) {
            MessageUtil.showWarning("survey.language.error.only_last_language_can_be_removed", new Object[0]);
            return;
        }
        if (this.selectedAssignedLanguage.getCode().equals(defaultLangCode)) {
            MessageUtil.showWarning("survey.language.error.cannot_remove_default_language", new Object[0]);
            return;
        }
        this.assignedLanguages.remove(this.selectedAssignedLanguage);
        this.selectedAssignedLanguage = null;
    }

    @Command
    public void applyChanges() {
        SessionStatus sessionStatus = this.getSessionStatus();
        final CollectSurvey survey = sessionStatus.getSurvey();
        final List<String> newLanguageCodes = this.getSelectedLanguageCodes();
        List<String> removedLanguages = this.calculateRemovedLanguages();
        if (removedLanguages.isEmpty()) {
            this.performLanguageUpdate(survey, newLanguageCodes);
        } else {
            MessageUtil.ConfirmParams confirmParams = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

                @Override
                public void onOk() {
                    SurveyLanguageVM.this.performLanguageUpdate(survey, newLanguageCodes);
                }
            }, "survey.language.remove.confirm");
            confirmParams.setOkLabelKey("global.remove_item");
            confirmParams.setMessageArgs(new String[]{StringUtils.join(removedLanguages, (String)", ")});
            MessageUtil.showConfirm(confirmParams);
        }
    }

    private void performLanguageUpdate(CollectSurvey survey, List<String> newLanguageCodes) {
        this.surveyManager.updateLanguages(survey, newLanguageCodes);
        if (this.assignedLanguages.isEmpty()) {
            MessageUtil.showWarning("survey.language.error.select_at_least_one_language", new Object[0]);
        } else {
            SessionStatus sessionStatus = this.getSessionStatus();
            sessionStatus.setCurrentLanguageCode(survey.getDefaultLanguage());
            BindUtils.postGlobalCommand(null, null, (String)SURVEY_LANGUAGES_CHANGED_COMMAND, null);
            BindUtils.postGlobalCommand(null, null, (String)CURRENT_LANGUAGE_CHANGED_COMMAND, null);
        }
    }

    private List<String> calculateRemovedLanguages() {
        SessionStatus sessionStatus = this.getSessionStatus();
        CollectSurvey survey = sessionStatus.getSurvey();
        List oldLanguageCodes = survey.getLanguages();
        List<String> newLanguageCodes = this.getSelectedLanguageCodes();
        ArrayList<String> removedLanguages = new ArrayList<String>();
        for (String oldLangCode : oldLanguageCodes) {
            if (newLanguageCodes.contains(oldLangCode)) continue;
            removedLanguages.add(Labels.getLabel((String)oldLangCode));
        }
        return removedLanguages;
    }

    @Command
    public void close() {
        BindUtils.postGlobalCommand(null, null, (String)CLOSE_SURVEY_LANGUAGE_SELECT_POPUP_COMMAND, null);
    }

    public List<LabelledItem> getAssignedLanguages() {
        return this.assignedLanguages;
    }

    @DependsOn(value={"assignedLanguages"})
    public List<LabelledItem> getUnassignedLanguages() {
        ArrayList<LabelledItem> result = new ArrayList<LabelledItem>(org.apache.commons.collections.CollectionUtils.disjunction(this.languages, this.assignedLanguages));
        Collections.sort(result, new LabelledItem.LabelComparator());
        return result;
    }

    @Command
    @NotifyChange(value={"assignedLanguages"})
    public void moveSelectedAssignedLanguageUp() {
        this.moveSelectedAssignedLanguage(true);
    }

    @Command
    @NotifyChange(value={"assignedLanguages"})
    public void moveSelectedAssignedLanguageDown() {
        this.moveSelectedAssignedLanguage(false);
    }

    protected void moveSelectedAssignedLanguage(boolean up) {
        int indexFrom = this.getSelectedAssignedLanguageIndex();
        int indexTo = up ? indexFrom - 1 : indexFrom + 1;
        this.moveSelectedAssignedLanguage(indexTo);
    }

    protected int getSelectedAssignedLanguageIndex() {
        int index = this.assignedLanguages.indexOf(this.selectedAssignedLanguage);
        return index;
    }

    protected void moveSelectedAssignedLanguage(int indexTo) {
        CollectionUtils.shiftItem(this.assignedLanguages, (Object)this.selectedAssignedLanguage, (int)indexTo);
    }

    @DependsOn(value={"assignedLanguages", "selectedAssignedLanguage"})
    public boolean isMoveSelectedAssignedLanguageUpDisabled() {
        return this.isMoveSelectedAssignedLanguageDisabled(true);
    }

    @DependsOn(value={"assignedLanguages", "selectedAssignedLanguage"})
    public boolean isMoveSelectedAssignedLanguageDownDisabled() {
        return this.isMoveSelectedAssignedLanguageDisabled(false);
    }

    protected boolean isMoveSelectedAssignedLanguageDisabled(boolean up) {
        if (this.selectedAssignedLanguage == null) {
            return true;
        }
        List<LabelledItem> siblings = this.assignedLanguages;
        int index = siblings.indexOf(this.selectedAssignedLanguage);
        return up ? index <= 0 : index < 0 || index >= siblings.size() - 1;
    }

    public LabelledItem getSelectedAssignedLanguage() {
        return this.selectedAssignedLanguage;
    }

    public void setSelectedAssignedLanguage(LabelledItem selectedAssignedLanguage) {
        this.selectedAssignedLanguage = selectedAssignedLanguage;
    }

    public LabelledItem getSelectedLanguageToAssign() {
        return this.selectedLanguageToAssign;
    }

    public void setSelectedLanguageToAssign(LabelledItem selectedLanguageToAssign) {
        this.selectedLanguageToAssign = selectedLanguageToAssign;
    }
}

