/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.impl.DialectAwareJooqConfiguration;
import org.openforis.collect.persistence.jooq.CollectDSLContext;

public class DbInitializer {
    private static final Logger LOG = LogManager.getLogger(DbInitializer.class);
    private ConnectionProvider connectionProvider;

    public DbInitializer(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void start() {
        DialectAwareJooqConfiguration jooqConf = new DialectAwareJooqConfiguration(this.connectionProvider);
        CollectDSLContext dslContext = new CollectDSLContext((Configuration)jooqConf);
        if (!dslContext.isSchemaLess()) {
            this.createDbSchema();
        }
    }

    private void createDbSchema() {
        Connection conn = null;
        try {
            LOG.info("Acquiring connection...");
            conn = this.connectionProvider.acquire();
            conn.setAutoCommit(false);
            LOG.info("Connection acquired!");
            LOG.info(String.format("Creating schema %s if not exists...", "collect"));
            if (this.createSchemaIfNotExists(conn)) {
                LOG.info(String.format("Schema '%s' created (if not existing already)", "collect"));
            } else {
                LOG.info("Try to create schema without 'IF NOT EXISTS' clause");
                boolean schemaCreated = this.createSchema(conn);
                LOG.info(String.format("Schema '%s' %s", "collect", schemaCreated ? "created" : "already exists"));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (conn != null) {
                this.connectionProvider.release(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSchemaIfNotExists(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(String.format("CREATE SCHEMA IF NOT EXISTS %s", "collect"));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.info("CREATE SCHEMA IF NOT EXISTS is not supported by this DBMS");
            boolean bl = false;
            return bl;
        }
        finally {
            this.commitQuietly(conn);
        }
    }

    private boolean createSchema(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(String.format("CREATE SCHEMA %s", "collect"));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean schemaAlreadyExists = e.getMessage().toLowerCase(Locale.ENGLISH).contains(" already ");
            if (schemaAlreadyExists) {
                boolean bl = false;
                return bl;
            }
            String errorMessage = String.format("Error creating schema '%s'", "collect");
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        finally {
            this.commitQuietly(conn);
        }
    }

    private void commitQuietly(Connection conn) {
        try {
            conn.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

