/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.config;

public abstract class CollectConfiguration {
    private static boolean developmentMode;
    private static String usersRestfulApiUrl;

    public static void initUsersServiceConfiguration(ServiceConfiguration usersServiceConfiguration) {
        usersRestfulApiUrl = usersServiceConfiguration.generateUrl() + "/of-users/api";
    }

    public static String getUsersRestfulApiUrl() {
        return usersRestfulApiUrl;
    }

    public static boolean isDevelopmentMode() {
        return developmentMode;
    }

    public static void setDevelopmentMode(boolean developmentMode) {
        CollectConfiguration.developmentMode = developmentMode;
    }

    public static class ServiceConfiguration {
        private String protocol;
        private String host;
        private int port;

        public ServiceConfiguration(String protocol, String host, int port) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
        }

        public String generateUrl() {
            return this.protocol + "://" + this.host + ":" + String.valueOf(this.port);
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

