/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.persistence;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.persistence.DataCleansingItemDao;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.persistence.jooq.Sequences;
import org.openforis.collect.persistence.jooq.SurveyObjectMappingDSLContext;
import org.openforis.collect.persistence.jooq.tables.OfcDataCleansingChain;
import org.openforis.collect.persistence.jooq.tables.OfcDataCleansingChainSteps;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataCleansingChainDao")
@Transactional
public class DataCleansingChainDao
extends DataCleansingItemDao<DataCleansingChain, JooqDSLContext> {
    public DataCleansingChainDao() {
        super(JooqDSLContext.class);
    }

    public List<DataCleansingChain> loadBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectSeekStep1 select = dsl.selectFrom((Table)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN).where(new Condition[]{OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.SURVEY_ID.eq((Object)survey.getId())}).orderBy((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.TITLE);
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        ((JooqDSLContext)this.dsl()).delete((Table)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN).where(new Condition[]{OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.SURVEY_ID.eq((Object)survey.getId())}).execute();
    }

    public Set<DataCleansingChain> loadChainsByStep(DataCleansingStep step) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)step.getSurvey());
        SelectSeekStep1 subselect = dsl.select((SelectField)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.CHAIN_ID).from((TableLike)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS).where(new Condition[]{OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.STEP_ID.eq((Object)step.getId())}).orderBy((Field)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.POS);
        SelectConditionStep select = dsl.selectFrom((Table)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN).where(new Condition[]{OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.ID.in((Select)subselect)});
        Result result = select.fetch();
        return new HashSet<DataCleansingChain>(dsl.fromResult(result));
    }

    public List<Integer> loadStepIds(DataCleansingChain chain) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)chain.getSurvey());
        SelectSeekStep1 select = dsl.select((SelectField)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.STEP_ID).from((TableLike)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS).where(new Condition[]{OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.CHAIN_ID.eq((Object)chain.getId())}).orderBy((Field)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.POS);
        List ids = select.fetch((Field)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.STEP_ID);
        return ids;
    }

    public void deleteStepAssociations(DataCleansingChain chain) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)chain.getSurvey());
        DeleteConditionStep query = dsl.delete((Table)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS).where(new Condition[]{OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.CHAIN_ID.eq((Object)chain.getId())});
        query.execute();
    }

    public void deleteStepAssociations(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        DeleteConditionStep query = dsl.delete((Table)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS).where(new Condition[]{OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.CHAIN_ID.in((Select)dsl.select((SelectField)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.ID).from((TableLike)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN).where(new Condition[]{OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.SURVEY_ID.eq((Object)survey.getId())}))});
        query.execute();
    }

    public void insertStepAssociations(DataCleansingChain chain, List<Integer> stepIds) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)chain.getSurvey());
        BatchBindStep batch = dsl.batch((Query)dsl.insertInto((Table)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS, (Field)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.CHAIN_ID, (Field)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.STEP_ID, (Field)OfcDataCleansingChainSteps.OFC_DATA_CLEANSING_CHAIN_STEPS.POS).values((Object)null, (Object)null, (Object)null));
        int position = 0;
        for (Integer stepId : stepIds) {
            batch.bind(new Object[]{chain.getId(), stepId, position++});
        }
        batch.execute();
    }

    protected static class JooqDSLContext
    extends SurveyObjectMappingDSLContext<Integer, DataCleansingChain> {
        private static final long serialVersionUID = 1L;

        public JooqDSLContext(Configuration config) {
            this(config, null);
        }

        public JooqDSLContext(Configuration config, CollectSurvey survey) {
            super(config, OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.ID, Sequences.OFC_DATA_CLEANSING_CHAIN_ID_SEQ, DataCleansingChain.class, survey);
        }

        protected DataCleansingChain newEntity() {
            return new DataCleansingChain(this.getSurvey());
        }

        protected void fromRecord(Record r, DataCleansingChain o) {
            super.fromRecord(r, (PersistedSurveyObject)o);
            o.setCreationDate((Date)r.getValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.CREATION_DATE));
            o.setDescription((String)r.getValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.DESCRIPTION));
            o.setModifiedDate((Date)r.getValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.MODIFIED_DATE));
            o.setTitle((String)r.getValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.TITLE));
            o.setUuid(UUID.fromString((String)r.getValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.UUID)));
        }

        protected void fromObject(DataCleansingChain o, StoreQuery<?> q) {
            super.fromObject((PersistedSurveyObject)o, q);
            q.addValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.SURVEY_ID, (Object)o.getSurvey().getId());
            q.addValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.CREATION_DATE, (Object)DataCleansingChainDao.toTimestamp((Date)o.getCreationDate()));
            q.addValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.DESCRIPTION, (Object)o.getDescription());
            q.addValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.MODIFIED_DATE, (Object)DataCleansingChainDao.toTimestamp((Date)o.getCreationDate()));
            q.addValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.TITLE, (Object)o.getTitle());
            q.addValue((Field)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.UUID, (Object)o.getUuid().toString());
        }
    }
}

