/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.AttributeDefinitionFormObject;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.EntityDefinition;

public class CodeAttributeDefinitionFormObject
extends AttributeDefinitionFormObject<CodeAttributeDefinition> {
    private CodeList list;
    private CodeAttributeDefinition parentCodeAttributeDefinition;
    private String parentCodeAttributeDefinitionPath;
    private boolean allowValuesSorting = false;
    private String layoutType;
    private boolean showAllowedValuesPreview = (Boolean)CollectAnnotations.Annotation.SHOW_ALLOWED_VALUES_PREVIEW.getDefaultValue();
    private String layoutDirection;
    private boolean showCode;
    private String hierarchicalLevel;

    public CodeAttributeDefinitionFormObject(EntityDefinition parentDefn) {
        super(parentDefn);
        this.layoutType = ((UIOptions.CodeAttributeLayoutType)CollectAnnotations.Annotation.CODE_ATTRIBUTE_LAYOUT_TYPE.getDefaultValue()).name();
        this.layoutDirection = ((UIOptions.Orientation)CollectAnnotations.Annotation.CODE_ATTRIBUTE_LAYOUT_DIRECTION.getDefaultValue()).name();
        this.showCode = (Boolean)CollectAnnotations.Annotation.CODE_ATTRIBUTE_SHOW_CODE.getDefaultValue();
    }

    @Override
    public void saveTo(CodeAttributeDefinition dest, String languageCode) {
        super.saveTo(dest, languageCode);
        dest.setList(this.list);
        dest.setParentCodeAttributeDefinition(this.parentCodeAttributeDefinition);
        dest.setAllowValuesSorting(dest.isMultiple() && this.allowValuesSorting);
        CollectSurvey survey = (CollectSurvey)dest.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        uiOptions.setShowAllowedValuesPreviewValue(dest, this.showAllowedValuesPreview);
        uiOptions.setLayoutType(dest, UIOptions.CodeAttributeLayoutType.valueOf((String)this.layoutType));
        uiOptions.setLayoutDirection(dest, StringUtils.isBlank((CharSequence)this.layoutDirection) ? null : UIOptions.Orientation.valueOf((String)this.layoutDirection));
        uiOptions.setShowCode(dest, this.showCode);
    }

    @Override
    public void loadFrom(CodeAttributeDefinition source, String languageCode) {
        super.loadFrom(source, languageCode);
        this.list = source.getList();
        this.setParentCodeAttributeDefinition(source.getParentCodeAttributeDefinition());
        this.hierarchicalLevel = this.extractHierarchicalLevel(source);
        this.allowValuesSorting = source.isMultiple() && source.isAllowValuesSorting();
        CollectSurvey survey = (CollectSurvey)source.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        this.showAllowedValuesPreview = uiOptions.getShowAllowedValuesPreviewValue(source);
        this.layoutType = uiOptions.getLayoutType(source).name();
        UIOptions.Orientation sourceItemsDirection = uiOptions.getLayoutDirection(source);
        this.layoutDirection = sourceItemsDirection == null ? null : sourceItemsDirection.name();
        this.showCode = uiOptions.getShowCode(source);
    }

    private String extractHierarchicalLevel(CodeAttributeDefinition source) {
        if (source.getList() == null) {
            return null;
        }
        try {
            return source.getHierarchicalLevel();
        }
        catch (Exception e) {
            return "---ERROR---";
        }
    }

    public CodeList getList() {
        return this.list;
    }

    public void setList(CodeList list) {
        this.list = list;
    }

    public boolean isAllowValuesSorting() {
        return this.allowValuesSorting;
    }

    public void setAllowValuesSorting(boolean allowValuesSorting) {
        this.allowValuesSorting = allowValuesSorting;
    }

    public CodeAttributeDefinition getParentCodeAttributeDefinition() {
        return this.parentCodeAttributeDefinition;
    }

    public void setParentCodeAttributeDefinition(CodeAttributeDefinition parentCodeAttributeDefinition) {
        this.parentCodeAttributeDefinition = parentCodeAttributeDefinition;
        this.parentCodeAttributeDefinitionPath = parentCodeAttributeDefinition == null ? null : parentCodeAttributeDefinition.getPath();
    }

    public String getParentCodeAttributeDefinitionPath() {
        return this.parentCodeAttributeDefinitionPath;
    }

    public void setParentCodeAttributeDefinitionPath(String parentCodeAttributeDefinitionPath) {
        this.parentCodeAttributeDefinitionPath = parentCodeAttributeDefinitionPath;
    }

    public String getHierarchicalLevel() {
        return this.hierarchicalLevel;
    }

    public void setHierarchicalLevel(String hierarchicalLevel) {
        this.hierarchicalLevel = hierarchicalLevel;
    }

    public String getLayoutDirection() {
        return this.layoutDirection;
    }

    public void setLayoutDirection(String layoutDirection) {
        this.layoutDirection = layoutDirection;
    }

    public String getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(String layoutType) {
        this.layoutType = layoutType;
    }

    public boolean isShowAllowedValuesPreview() {
        return this.showAllowedValuesPreview;
    }

    public void setShowAllowedValuesPreview(boolean showAllowedValuesPreview) {
        this.showAllowedValuesPreview = showAllowedValuesPreview;
    }

    public boolean isShowCode() {
        return this.showCode;
    }

    public void setShowCode(boolean showCode) {
        this.showCode = showCode;
    }
}

