/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.openforis.collect.designer.util.MediaUtil;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Filedownload;

public abstract class BaseSurveyFileImportVM
extends SurveyBaseVM {
    protected File uploadedFile;
    protected String uploadedFileName;
    private String[] allowedFileExtensions;
    private String exampleFileName;

    public BaseSurveyFileImportVM(String[] allowedFileExtensions, String exampleFileName) {
        this.allowedFileExtensions = allowedFileExtensions;
        this.exampleFileName = exampleFileName;
        this.reset();
    }

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
    }

    protected void reset() {
        if (this.uploadedFile != null) {
            this.uploadedFile.delete();
            this.uploadedFile = null;
        }
        this.uploadedFileName = null;
        this.notifyChange("uploadedFileName");
    }

    @Command
    public void fileUploaded(@ContextParam(value=ContextType.TRIGGER_EVENT) UploadEvent event) {
        Media media = event.getMedia();
        this.checkCanImportFile(media);
        this.uploadedFile = MediaUtil.copyToTempFile(media);
        this.uploadedFileName = media.getName();
        this.notifyChange("uploadedFileName");
    }

    @Command
    public void downloadExample() {
        ServletContext context = this.getSession().getWebApp().getServletContext();
        InputStream is = context.getResourceAsStream("/WEB-INF/resources/io/" + this.exampleFileName);
        Filedownload.save((InputStream)is, (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (String)this.exampleFileName);
    }

    private void checkCanImportFile(Media media) {
        String fileName = media.getName();
        String extension = FilenameUtils.getExtension((String)fileName).toLowerCase(Locale.ENGLISH);
        if (!Arrays.asList(this.allowedFileExtensions).contains(extension)) {
            throw new RuntimeException(String.format("Only %s file upload is supported, found: %s", String.join((CharSequence)",", this.allowedFileExtensions), extension));
        }
    }

    protected boolean validateForm(BindContext ctx) {
        String messageKey = null;
        if (this.uploadedFile == null) {
            messageKey = "global.file_not_selected";
        }
        if (messageKey == null) {
            return true;
        }
        MessageUtil.showWarning(messageKey, new Object[0]);
        return false;
    }

    public String getUploadedFileName() {
        return this.uploadedFileName;
    }
}

