/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.openforis.collect.designer.form.SurveyObjectFormObject;
import org.openforis.collect.designer.form.UnitFormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyErrorsPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Unit;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Window;

public class UnitsVM
extends SurveyObjectBaseVM<Unit> {
    private static final String UNITS_UPDATED_GLOBAL_COMMAND = "unitsUpdated";
    private Window confirmDeleteItemWithErrorsPopUp;

    public static String getDimensionLabel(Unit.Dimension dimension) {
        String labelKey = "survey.unit.dimension." + dimension.name().toLowerCase(Locale.ENGLISH);
        String label = Labels.getLabel((String)labelKey);
        return label;
    }

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
    }

    @Override
    @AfterCompose
    public void doAfterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        super.doAfterCompose(view);
    }

    @Override
    protected List<Unit> getItemsInternal() {
        CollectSurvey survey = this.getSurvey();
        List units = survey.getUnits();
        return units;
    }

    @Override
    protected Unit createItemInstance() {
        Unit instance = this.survey.createUnit();
        return instance;
    }

    @Override
    protected void addNewItemToSurvey() {
        CollectSurvey survey = this.getSurvey();
        survey.addUnit((Unit)this.editedItem);
    }

    @Override
    protected void deleteItemFromSurvey(Unit item) {
        CollectSurvey survey = this.getSurvey();
        survey.removeUnit(item);
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
        this.survey.moveUnit((Unit)this.selectedItem, indexTo);
    }

    @Override
    protected SurveyObjectFormObject<Unit> createFormObject() {
        return new UnitFormObject();
    }

    @Override
    @Command
    @NotifyChange(value={"editedItem", "selectedItem"})
    public void applyChanges(@ContextParam(value=ContextType.BINDER) Binder binder) {
        super.applyChanges(binder);
        this.dispatchUnitsUpdatedCommand();
    }

    protected void dispatchUnitsUpdatedCommand() {
        BindUtils.postGlobalCommand(null, null, (String)UNITS_UPDATED_GLOBAL_COMMAND, null);
    }

    @Command
    public void deleteUnit(final @BindingParam(value="item") Unit item) {
        List<NodeDefinition> references = this.getReferences(item);
        if (references.isEmpty()) {
            super.deleteItem(item);
        } else {
            String title = Labels.getLabel((String)"survey.unit.delete.confirm_title");
            String message = Labels.getLabel((String)"survey.unit.delete.confirm_in_use");
            this.confirmDeleteItemWithErrorsPopUp = SurveyErrorsPopUpVM.openPopUp(title, message, references, new MessageUtil.CompleteConfirmHandler(){

                @Override
                public void onOk() {
                    UnitsVM.this.performDeleteItem(item);
                    UnitsVM.this.closeErrorsInNodesPopUp();
                }

                @Override
                public void onCancel() {
                    UnitsVM.this.closeErrorsInNodesPopUp();
                }
            });
        }
    }

    @Override
    protected void performDeleteItem(Unit item) {
        super.performDeleteItem(item);
        this.dispatchUnitsUpdatedCommand();
    }

    protected void closeErrorsInNodesPopUp() {
        UnitsVM.closePopUp(this.confirmDeleteItemWithErrorsPopUp);
        this.confirmDeleteItemWithErrorsPopUp = null;
    }

    protected List<NodeDefinition> getReferences(Unit item) {
        ArrayList<NodeDefinition> references = new ArrayList<NodeDefinition>();
        Schema schema = this.survey.getSchema();
        List rootEntities = schema.getRootEntityDefinitions();
        Stack stack = new Stack();
        stack.addAll(rootEntities);
        while (!stack.isEmpty()) {
            List units;
            NodeDefinition defn = (NodeDefinition)stack.pop();
            if (defn instanceof EntityDefinition) {
                stack.addAll(((EntityDefinition)defn).getChildDefinitions());
                continue;
            }
            if (!(defn instanceof NumericAttributeDefinition) || !(units = ((NumericAttributeDefinition)defn).getUnits()).contains(item)) continue;
            references.add(defn);
        }
        return references;
    }

    public List<String> getAvailableDimensions() {
        Unit.Dimension[] dimensions = Unit.Dimension.values();
        ArrayList<String> result = new ArrayList<String>(dimensions.length);
        for (Unit.Dimension dimension : dimensions) {
            String label = UnitsVM.getDimensionLabel(dimension);
            result.add(label);
        }
        return result;
    }

    @Command
    public void apply(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.checkCanLeaveForm(new SurveyBaseVM.CanLeaveFormConfirmHandler(){

            @Override
            public void onOk(boolean confirmed) {
                BindUtils.postGlobalCommand(null, null, (String)"closeUnitsManagerPopUp", null);
            }
        });
    }
}

