/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.validator;

import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.manager.ImageryManager;
import org.openforis.collect.model.Imagery;
import org.openforis.collect.web.controller.ImageryController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class ImageryValidator
extends SimpleValidator<ImageryController.ImageryForm> {
    private static final String TITLE_FIELD = "title";
    @Autowired
    private ImageryManager imageryManager;

    @Override
    public void validateForm(ImageryController.ImageryForm target, Errors errors) {
        if (this.validateRequiredField(errors, TITLE_FIELD)) {
            this.validateUniqueness(target, errors);
        }
    }

    private boolean validateUniqueness(ImageryController.ImageryForm target, Errors errors) {
        Imagery duplicate = this.imageryManager.findByTitle(target.getTitle());
        if (!(duplicate == null || target.getId() != null && duplicate.getId().equals(target.getId()))) {
            this.rejectDuplicateValue(errors, TITLE_FIELD, new Object[0]);
            return false;
        }
        return true;
    }
}

