/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.DataQueryGroupExectutorTask;
import org.openforis.collect.datacleansing.DataQueryResultProcessor;
import org.openforis.collect.datacleansing.DataReport;
import org.openforis.collect.datacleansing.DataReportItem;
import org.openforis.collect.datacleansing.json.JSONValueFormatter;
import org.openforis.collect.datacleansing.manager.DataReportManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Worker;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DataReportGeneratorJob
extends Job {
    @Autowired
    private DataReportManager reportManager;
    private DataQueryGroup errorQueryGroup;
    private CollectRecord.Step recordStep;
    private User activeUser;
    private DataReport report;
    private transient ItemBatchPersister batchPersister;

    protected void buildTasks() throws Throwable {
        DataQueryGroupExectutorTask task = (DataQueryGroupExectutorTask)this.addTask(DataQueryGroupExectutorTask.class);
        task.setInput(new DataQueryGroupExectutorTask.DataQueryGroupExecutorTaskInput((CollectSurvey)this.errorQueryGroup.getSurvey(), this.errorQueryGroup.getQueries(), this.recordStep, new ReportItemPersisterNodeProcessor()));
    }

    protected void initializeTask(Worker task) {
        super.initializeTask(task);
        this.report = new DataReport((CollectSurvey)this.errorQueryGroup.getSurvey());
        this.report.setQueryGroup(this.errorQueryGroup);
        this.report.setRecordStep(this.recordStep);
        this.reportManager.save(this.report, this.activeUser);
        this.batchPersister = new ItemBatchPersister(this.report);
    }

    protected void onTaskCompleted(Worker task) {
        if (task instanceof DataQueryGroupExectutorTask) {
            DataQueryGroupExectutorTask t = (DataQueryGroupExectutorTask)task;
            this.report.setDatasetSize(Long.valueOf(t.getTotalItems()).intValue());
            this.report.setLastRecordModifiedDate(t.getLastRecordModifiedDate());
            this.reportManager.save(this.report, this.activeUser);
        }
        super.onTaskCompleted(task);
    }

    protected void onCompleted() {
        super.onCompleted();
        this.batchPersister.flush();
    }

    public void setQueryGroup(DataQueryGroup errorQueryGroup) {
        this.errorQueryGroup = errorQueryGroup;
    }

    public void setRecordStep(CollectRecord.Step recordStep) {
        this.recordStep = recordStep;
    }

    public void setActiveUser(User activeUser) {
        this.activeUser = activeUser;
    }

    public DataReport getReport() {
        return this.report;
    }

    private DataReportItem createReportItem(DataReport report, DataQuery query, Attribute<?, ?> attr) {
        DataReportItem item = new DataReportItem(report, query);
        item.setRecordId(attr.getRecord().getId());
        item.setParentEntityId(attr.getParent().getInternalId());
        item.setNodeIndex(attr.getIndex());
        item.setValue(new JSONValueFormatter().formatValue(attr));
        return item;
    }

    private class ItemBatchPersister {
        private static final int MAX_SIZE = 10000;
        private List<DataReportItem> items = new ArrayList<DataReportItem>();
        private DataReport report;

        public ItemBatchPersister(DataReport report) {
        }

        public void add(DataReportItem item) {
            this.items.add(item);
            if (this.items.size() > 10000) {
                this.flush();
            }
        }

        public void flush() {
            if (!this.items.isEmpty()) {
                DataReportGeneratorJob.this.reportManager.saveItems(this.report, this.items);
                this.items.clear();
            }
        }
    }

    private class ReportItemPersisterNodeProcessor
    implements DataQueryResultProcessor {
        private ReportItemPersisterNodeProcessor() {
        }

        @Override
        public void init() throws Exception {
        }

        @Override
        public void process(DataQuery query, Node<?> node) throws Exception {
            DataReportItem item = DataReportGeneratorJob.this.createReportItem(DataReportGeneratorJob.this.report, query, (Attribute)node);
            DataReportGeneratorJob.this.batchPersister.add(item);
        }

        @Override
        public void close() throws IOException {
            DataReportGeneratorJob.this.batchPersister.flush();
        }
    }
}

