/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.manager;

import java.util.List;
import java.util.Set;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.manager.DataQueryManager;
import org.openforis.collect.datacleansing.persistence.DataQueryGroupDao;
import org.openforis.collect.manager.AbstractSurveyObjectManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DataQueryGroupManager
extends AbstractSurveyObjectManager<Integer, DataQueryGroup, DataQueryGroupDao> {
    @Autowired
    private DataQueryManager dataQueryManager;

    public Set<DataQueryGroup> loadByQuery(DataQuery query) {
        Set<DataQueryGroup> groups = ((DataQueryGroupDao)this.dao).loadGroupsByQuery(query);
        this.initializeItems(groups);
        return groups;
    }

    @Transactional
    public DataQueryGroup save(DataQueryGroup group, User activeUser) {
        List queryIds = CollectionUtils.project(group.getQueries(), (String)"id");
        if (group.getId() != null) {
            ((DataQueryGroupDao)this.dao).deleteQueryAssociations(group);
        }
        super.save((PersistedSurveyObject)group, activeUser);
        ((DataQueryGroupDao)this.dao).insertQueryAssociations(group, queryIds);
        this.initializeItem(group);
        return group;
    }

    @Transactional
    public void delete(DataQueryGroup group) {
        ((DataQueryGroupDao)this.dao).deleteQueryAssociations(group);
        super.delete((PersistedSurveyObject)group);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        ((DataQueryGroupDao)this.dao).deleteQueryAssociations(survey);
        super.deleteBySurvey(survey);
    }

    protected void initializeItem(DataQueryGroup group) {
        super.initializeItem((PersistedSurveyObject)group);
        group.removeAllQueries();
        List<Integer> queryIds = ((DataQueryGroupDao)this.dao).loadQueryIds(group);
        for (Integer queryId : queryIds) {
            DataQuery query = (DataQuery)this.dataQueryManager.loadById((CollectSurvey)group.getSurvey(), queryId);
            group.addQuery(query);
        }
    }
}

