/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.form.SurveyMainInfoFormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SurveyFile;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Window;

public class SurveyMainInfoVM
extends SurveyObjectBaseVM<CollectSurvey> {
    @WireVariable
    private SurveyManager surveyManager;
    private boolean editingNewSurveyFile;
    private SurveyFile editedSurveyFile;
    private Set<SurveyFile> selectedSurveyFiles = new HashSet<SurveyFile>();
    private Window surveyFilePopUp;

    @Init(superclass=false)
    public void init(@ContextParam(value=ContextType.BINDER) Binder binder) {
        super.init();
        this.setEditedItem(this.getSurvey());
        this.validateForm(binder);
    }

    @Override
    protected void performItemSelection(CollectSurvey item) {
        super.performItemSelection(item);
        this.dispatchValidateAllCommand();
    }

    @Override
    protected CollectSurvey createItemInstance() {
        return null;
    }

    @Override
    protected FormObject<CollectSurvey> createFormObject() {
        return new SurveyMainInfoFormObject();
    }

    @Override
    protected List<CollectSurvey> getItemsInternal() {
        return null;
    }

    @Override
    protected void addNewItemToSurvey() {
    }

    @Override
    protected void deleteItemFromSurvey(CollectSurvey item) {
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
    }

    public SurveyManager getSurveyManager() {
        return this.surveyManager;
    }

    public Integer getEditedSurveyPublishedId() {
        return this.getSessionStatus().getPublishedSurveyId();
    }

    public String getSurveyFileTypeLabel(SurveyFile surveyFile) {
        SurveyFile.SurveyFileType type = surveyFile.getType();
        return Labels.getLabel((String)("survey.file.type." + type.name().toLowerCase(Locale.ENGLISH)));
    }

    public String getSurveyFileName(SurveyFile surveyFile) {
        return surveyFile.getFilename();
    }

    public List<SurveyFile> getSurveyFiles() {
        return this.survey == null ? null : this.surveyManager.loadSurveyFileSummaries(this.survey);
    }

    @Command
    public void addSurveyFile() {
        this.editedSurveyFile = new SurveyFile(this.survey);
        this.editingNewSurveyFile = true;
        this.openSurveyFileEditPopUp();
    }

    @Command
    public void editSelectedSurveyFile() {
        if (!this.isSingleSurveyFileSelected()) {
            return;
        }
        this.editedSurveyFile = this.selectedSurveyFiles.iterator().next();
        this.editingNewSurveyFile = false;
        this.openSurveyFileEditPopUp();
    }

    @Command
    public void downloadSelectedSurveyFile() {
        if (!this.isSingleSurveyFileSelected()) {
            return;
        }
        SurveyFile selectedSurveyFile = this.selectedSurveyFiles.iterator().next();
        byte[] content = this.surveyManager.loadSurveyFileContent(selectedSurveyFile);
        String fileName = selectedSurveyFile.getFilename();
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        Filedownload.save((byte[])content, (String)contentType, (String)fileName);
    }

    @GlobalCommand
    public void applyChangesToEditedSurveyFile(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.closeSurveyFileEditPopUp(binder);
        this.notifyChange("surveyFiles");
    }

    private void openSurveyFileEditPopUp() {
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("newItem", this.editingNewSurveyFile);
        args.put("surveyFile", (Boolean)this.editedSurveyFile);
        this.surveyFilePopUp = SurveyMainInfoVM.openPopUp(Resources.Component.SURVEY_FILE_POPUP.getLocation(), true, args);
    }

    @GlobalCommand
    public void closeSurveyFileEditPopUp(@ContextParam(value=ContextType.BINDER) Binder binder) {
        SurveyMainInfoVM.closePopUp(this.surveyFilePopUp);
        this.surveyFilePopUp = null;
        this.validateForm(binder);
    }

    @Command
    public void deleteSelectedSurveyFiles() {
        Object[] objectArray;
        String messageKey;
        if (this.selectedSurveyFiles.isEmpty()) {
            return;
        }
        String string = messageKey = this.isSingleSurveyFileSelected() ? "survey.file.delete.confirm" : "survey.file.delete_multiple.confirm";
        if (this.isSingleSurveyFileSelected()) {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = this.selectedSurveyFiles.iterator().next().getFilename();
        } else {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = Integer.toString(this.selectedSurveyFiles.size());
        }
        Object[] messageArgs = objectArray;
        MessageUtil.showConfirm(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                SurveyMainInfoVM.this.surveyManager.deleteSurveyFiles(SurveyMainInfoVM.this.selectedSurveyFiles);
                SurveyMainInfoVM.this.setSelectedSurveyFiles(new HashSet<SurveyFile>());
                SurveyMainInfoVM.this.notifyChange("surveyFiles", "selectedSurveyFiles");
            }
        }, messageKey, messageArgs);
    }

    public boolean isSingleSurveyFileSelected() {
        return this.selectedSurveyFiles.size() == 1;
    }

    public Set<SurveyFile> getSelectedSurveyFiles() {
        return this.selectedSurveyFiles;
    }

    public void setSelectedSurveyFiles(Set<SurveyFile> selectedSurveyFiles) {
        this.selectedSurveyFiles = selectedSurveyFiles;
        this.notifyChange("singleSurveyFileSelected");
    }
}

