/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.model.NamedObject;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.model.CollectSurvey;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Window;

public class TabsGroupVM
extends BaseVM {
    private static final String TAB_NAME_PREFIX = "tab_";
    private static final String TAB_NAME_SEPARATOR = "_";
    public static final String TAB_CHANGED_GLOBAL_COMMAND = "tabChanged";
    public static NamedObject FAKE_ADD_TAB = new NamedObject("survey.layout.tab.add_short");
    @Wire
    private Tabbox tabbox;
    private UITabSet tabSet;
    private Window tabLabelPopUp;

    @Init
    public void init(@ExecutionArgParam(value="tabSet") UITabSet tabSet) {
        this.tabSet = tabSet;
    }

    @AfterCompose
    public void afterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        Selectors.wireComponents((Component)view, (Object)this, (boolean)false);
    }

    @Command
    @NotifyChange(value={"tabs"})
    public void addTab() {
        UIOptions uiOptions = this.tabSet.getUIOptions();
        UITab tab = uiOptions.createTab();
        String tabName = this.generateNewTabName(this.tabSet);
        tab.setName(tabName);
        this.tabSet.addTab(tab);
        this.postTabChangedCommand(this.tabSet);
        this.openTabLabelEditPopUp(tab);
    }

    @Command
    public void editTabLabel(@BindingParam(value="tab") UITab tab) {
        this.openTabLabelEditPopUp(tab);
    }

    @Command
    @NotifyChange(value={"tabs"})
    public void removeTab(@BindingParam(value="tab") UITab tab) {
        if (tab.getTabs().isEmpty()) {
            SessionStatus sessionStatus = this.getSessionStatus();
            CollectSurvey survey = sessionStatus.getSurvey();
            UIOptions uiOpts = survey.getUIOptions();
            List nodesPerTab = uiOpts.getNodesPerTab(tab, false);
            if (nodesPerTab.isEmpty()) {
                UITabSet parent = tab.getParent();
                parent.removeTab(tab);
                this.postTabChangedCommand(parent);
            } else {
                MessageUtil.showWarning("survey.layout.tab.remove.error.associated_nodes_present", new Object[0]);
            }
        } else {
            MessageUtil.showWarning("survey.layout.tab.remove.error.nested_tabs_present", new Object[0]);
        }
    }

    protected void openTabLabelEditPopUp(UITab tab) {
        HashMap<String, UITab> args = new HashMap<String, UITab>();
        args.put("tab", tab);
        this.tabLabelPopUp = TabsGroupVM.openPopUp(Resources.Component.TAB_LABEL_POPUP.getLocation(), true, args);
    }

    @GlobalCommand
    public void applyChangesToTabLabel(@BindingParam(value="tab") UITab tab, @BindingParam(value="label") String label) {
        UITabSet parent = tab.getParent();
        if (parent.equals((Object)this.tabSet) && this.validateTabLabel(label)) {
            this.performUpdateTabLabel(tab, label);
        }
    }

    protected void performUpdateTabLabel(UITab tab, String label) {
        List tabs = this.tabSet.getTabs();
        int index = tabs.indexOf(tab);
        this.tabbox.setSelectedIndex(index);
        tab.setLabel(this.getCurrentLanguageCode(), label.trim());
        TabsGroupVM.closePopUp(this.tabLabelPopUp);
        BindUtils.postNotifyChange(null, null, (Object)tab, (String)"*");
    }

    protected boolean validateTabLabel(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            MessageUtil.showWarning("survey.layout.tab.label.error.required", new Object[0]);
            return false;
        }
        return true;
    }

    private void postTabChangedCommand(UITabSet parent) {
        HashMap<String, UITabSet> args = new HashMap<String, UITabSet>();
        args.put("tab", parent);
        BindUtils.postGlobalCommand(null, null, (String)TAB_CHANGED_GLOBAL_COMMAND, args);
    }

    private String generateNewTabName(UITabSet parentGroup) {
        String prefix = TAB_NAME_PREFIX;
        Stack<Integer> parts = new Stack<Integer>();
        UITabSet currentGroup = parentGroup;
        do {
            int position = currentGroup.getTabs().size() + 1;
            parts.push(position);
        } while ((currentGroup = currentGroup.getParent()) != null);
        String suffix = StringUtils.join((Object[])parts.toArray(), (String)TAB_NAME_SEPARATOR);
        String tabName = prefix + suffix;
        return tabName;
    }

    public UITabSet getTabsGroup() {
        return this.tabSet;
    }

    public List<UITab> getTabs() {
        return this.tabSet != null ? this.tabSet.getTabs() : null;
    }

    @DependsOn(value={"tabs"})
    public List<Object> getTabsPlusAddButton() {
        ArrayList<Object> tabs = new ArrayList<Object>();
        if (this.tabSet != null) {
            tabs.addAll(this.tabSet.getTabs());
        }
        tabs.add(FAKE_ADD_TAB);
        return tabs;
    }

    public NamedObject getFakeAddTab() {
        return FAKE_ADD_TAB;
    }
}

