/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openforis.collect.client.AbstractClient;
import org.openforis.collect.config.CollectConfiguration;
import org.openforis.collect.manager.CannotDeleteUserException;
import org.openforis.collect.manager.OperationResult;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.manager.UserPersistenceException;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserRole;

public class ClientUserManager
extends AbstractClient
implements UserManager {
    public User loadById(Integer userId) {
        User user = this.getOne(CollectConfiguration.getUsersRestfulApiUrl() + "/user/" + userId, User.class);
        this.setGenericRoles(user);
        return user;
    }

    public User loadByUserName(String userName) {
        List<User> list = this.getList(String.format(CollectConfiguration.getUsersRestfulApiUrl() + "/user?username=%s", userName), User.class);
        this.adaptRoles(list);
        return list.isEmpty() ? null : list.get(0);
    }

    public User loadEnabledUser(String userName) {
        List<User> list = this.getList(String.format(CollectConfiguration.getUsersRestfulApiUrl() + "/user?username=%s&enabled=true", userName), User.class);
        this.adaptRoles(list);
        return list.isEmpty() ? null : list.get(0);
    }

    public User loadAdminUser() {
        User user = this.loadByUserName("admin");
        this.setGenericRoles(user);
        return user;
    }

    public List<User> loadAll() {
        List<User> list = this.getList(String.format(CollectConfiguration.getUsersRestfulApiUrl() + "/user", new Object[0]), User.class);
        this.adaptRoles(list);
        return list;
    }

    public List<User> loadAllAvailableUsers(User availableTo) {
        return null;
    }

    public User save(User user, User modifiedByUser) throws UserPersistenceException {
        User result = this.post(CollectConfiguration.getUsersRestfulApiUrl() + "/user", user, User.class);
        user.setId(result.getId());
        return user;
    }

    public User insertUser(String name, String rawPassword, UserRole role, User createdByUser) throws UserPersistenceException {
        User user = new User(name);
        user.setRawPassword(rawPassword);
        user.addRole(role);
        this.save(user, createdByUser);
        return user;
    }

    public boolean verifyPassword(final String username, final String password) {
        Map result = this.post(CollectConfiguration.getUsersRestfulApiUrl() + "/login", new HashMap<String, Object>(){
            {
                this.put("username", username);
                this.put("rawPassword", password);
            }
        }, Map.class);
        return (Boolean)result.get("success");
    }

    public OperationResult changePassword(final String username, final String oldPassword, final String newPassword) throws UserPersistenceException {
        OperationResult result = this.post(CollectConfiguration.getUsersRestfulApiUrl() + "/change-password", new HashMap<String, Object>(){
            {
                this.put("username", username);
                this.put("oldPassword", oldPassword);
                this.put("newPassword", newPassword);
            }
        }, OperationResult.class);
        return result;
    }

    public Boolean isDefaultAdminPasswordSet() {
        return this.verifyPassword("admin", "Collect123");
    }

    public void deleteById(Integer id) throws CannotDeleteUserException {
        this.delete(CollectConfiguration.getUsersRestfulApiUrl() + "/user/" + id);
    }

    public void delete(User user) {
        this.deleteById(user.getId());
    }

    private void adaptRoles(List<User> list) {
        for (User user : list) {
            this.setGenericRoles(user);
        }
    }

    private void setGenericRoles(User user) {
        if (user != null) {
            UserRole role = UserRole.ADMIN;
            user.setRoles(Arrays.asList(role));
        }
    }
}

