/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openforis.collect.event.EventListener;
import org.openforis.collect.event.RecordEvent;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SessionRecordFileManager;
import org.openforis.collect.manager.exception.RecordFileException;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.persistence.RecordUnlockedException;
import org.springframework.beans.factory.annotation.Autowired;

public class RecordSessionManager
extends SessionManager
implements EventListener {
    @Autowired
    private transient SessionRecordFileManager recordFileManager;
    private transient List<RecordEvent> pendingEvents = new CopyOnWriteArrayList<RecordEvent>();

    public void onEvent(RecordEvent event) {
        this.pendingEvents.add(event);
    }

    @Override
    public void setActiveRecord(CollectRecord record) {
        super.setActiveRecord(record);
        this.recordFileManager.resetTempInfo();
    }

    @Override
    public void releaseRecord() throws RecordUnlockedException {
        super.releaseRecord();
        this.recordFileManager.deleteAllTempFiles();
        this.pendingEvents.clear();
    }

    public List<RecordEvent> flushPendingEvents() {
        if (this.pendingEvents.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RecordEvent> events = new ArrayList<RecordEvent>(this.pendingEvents);
        this.pendingEvents.clear();
        return events;
    }

    public boolean commitRecordFileChanges(CollectRecord record) throws RecordFileException {
        return this.recordFileManager.commitChanges(record);
    }

    public void indexTempRecordFile(File tempFile, Integer nodeId) {
        this.recordFileManager.indexTempFile(nodeId.intValue(), tempFile, tempFile.getName());
    }

    public void prepareDeleteTempRecordFile(CollectRecord record, Integer nodeId) {
        this.recordFileManager.prepareDeleteFile(record, nodeId.intValue());
    }
}

