/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.sql.SQLException;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.concurrency.SurveyLockingJob;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.relational.CollectRdbException;
import org.openforis.collect.reporting.ReportingRepositories;
import org.openforis.collect.reporting.ReportingRepositoriesGeneratorJob;
import org.openforis.collect.reporting.ReportingRepositoryInfo;
import org.openforis.commons.web.Response;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.proxy.JobProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/saiku/"})
public class SaikuController {
    @Autowired
    private ReportingRepositories reportingRepositories;
    @Autowired
    private CollectJobManager jobManager;
    @Autowired
    private SurveyManager surveyManager;

    @RequestMapping(value={"datasources/{surveyName}/generate"}, method={RequestMethod.POST})
    @ResponseBody
    public JobProxy generateRepository(@PathVariable String surveyName, @RequestParam String language) throws CollectRdbException, SQLException {
        CollectSurvey survey = this.surveyManager.get(surveyName);
        ReportingRepositoriesGeneratorJob job = (ReportingRepositoriesGeneratorJob)this.jobManager.createJob(ReportingRepositoriesGeneratorJob.class);
        job.setInput(new ReportingRepositoriesGeneratorJob.Input(language));
        job.setSurvey(survey);
        this.jobManager.startSurveyJob((SurveyLockingJob)job);
        return new JobProxy((Job)job);
    }

    @RequestMapping(value={"datasources/{surveyName}/info"}, method={RequestMethod.GET})
    @ResponseBody
    public Response getInfo(@PathVariable String surveyName) {
        ReportingRepositoryInfo info = this.reportingRepositories.getInfo(surveyName);
        Response response = new Response();
        response.setObject((Object)info);
        return response;
    }
}

