/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryEvaluator;
import org.openforis.collect.datacleansing.DataQueryResultProcessor;
import org.openforis.collect.datacleansing.xpath.XPathDataQueryEvaluator;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.concurrency.Task;
import org.openforis.idm.model.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class DataQueryGroupExectutorTask
extends Task {
    @Autowired
    private RecordManager recordManager;
    DataQueryGroupExecutorTaskInput input;
    private List<DataQueryExecutorError> errors;
    private Date lastRecordModifiedDate;

    protected long countTotalItems() {
        RecordFilter recordsFilter = this.createRecordsFilter();
        int count = this.recordManager.countRecords(recordsFilter);
        return count;
    }

    protected void initializeInternalVariables() throws Throwable {
        super.initializeInternalVariables();
        this.errors = new ArrayList<DataQueryExecutorError>();
    }

    protected void onCompleted() {
        super.onCompleted();
        IOUtils.closeQuietly((Closeable)this.input.resultProcessor);
    }

    @Transactional
    protected void execute() throws Throwable {
        CollectSurvey survey = this.input.getSurvey();
        RecordFilter filter = this.createRecordsFilter();
        List recordSummaries = this.recordManager.loadSummaries(filter);
        Iterator it = recordSummaries.iterator();
        while (it.hasNext() && this.isRunning()) {
            CollectRecordSummary recordSummary = (CollectRecordSummary)it.next();
            Date modifiedDate = recordSummary.getModifiedDate();
            if (this.lastRecordModifiedDate == null) {
                this.lastRecordModifiedDate = modifiedDate;
            } else if (modifiedDate.compareTo(this.lastRecordModifiedDate) > 0) {
                this.lastRecordModifiedDate = modifiedDate;
            }
            CollectRecord record = this.recordManager.load(survey, recordSummary.getId().intValue(), this.input.step, false);
            List<DataQuery> queries = this.input.getQueries();
            for (DataQuery query : queries) {
                DataQueryEvaluator queryEvaluator = this.createQueryEvaluator(query);
                List<Node<?>> nodes = queryEvaluator.evaluate(record);
                for (Node<?> node : nodes) {
                    this.processNode(query, node);
                }
            }
            this.incrementProcessedItems();
        }
    }

    private void processNode(DataQuery query, Node<?> node) {
        try {
            this.input.resultProcessor.process(query, node);
        }
        catch (Exception e) {
            this.log().error((Object)String.format("Error executing query %s", query.getId()), (Throwable)e);
            CollectRecord record = (CollectRecord)node.getRecord();
            this.errors.add(new DataQueryExecutorError(record.getRootEntityKeyValues(), record.getId(), node.getPath(), e.getMessage()));
        }
    }

    private RecordFilter createRecordsFilter() {
        CollectSurvey survey = this.input.getSurvey();
        RecordFilter filter = new RecordFilter(survey);
        filter.setStep(this.input.step);
        filter.setOffset(Integer.valueOf(0));
        filter.setMaxNumberOfRecords(this.input.maxRecords);
        return filter;
    }

    private DataQueryEvaluator createQueryEvaluator(DataQuery query) {
        return new XPathDataQueryEvaluator(query);
    }

    public DataQueryGroupExecutorTaskInput getInput() {
        return this.input;
    }

    public void setInput(DataQueryGroupExecutorTaskInput input) {
        this.input = input;
    }

    public Date getLastRecordModifiedDate() {
        return this.lastRecordModifiedDate;
    }

    public static class DataQueryGroupExecutorTaskInput {
        private CollectSurvey survey;
        private List<DataQuery> queries;
        private CollectRecord.Step step;
        private Integer maxRecords;
        private DataQueryResultProcessor resultProcessor;

        public DataQueryGroupExecutorTaskInput(CollectSurvey survey, List<DataQuery> queries, CollectRecord.Step step, DataQueryResultProcessor resultProcessor) {
            this(survey, queries, step, resultProcessor, null);
        }

        public DataQueryGroupExecutorTaskInput(CollectSurvey survey, List<DataQuery> queries, CollectRecord.Step step, DataQueryResultProcessor resultProcessor, Integer maxRecords) {
            this.survey = survey;
            this.queries = queries;
            this.step = step;
            this.resultProcessor = resultProcessor;
            this.maxRecords = maxRecords;
        }

        public CollectSurvey getSurvey() {
            return this.survey;
        }

        public List<DataQuery> getQueries() {
            return this.queries;
        }

        public void setQueries(List<DataQuery> queries) {
            this.queries = queries;
        }

        public CollectRecord.Step getStep() {
            return this.step;
        }

        public void setStep(CollectRecord.Step step) {
            this.step = step;
        }

        public Integer getMaxRecords() {
            return this.maxRecords;
        }

        public void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public DataQueryResultProcessor getResultProcessor() {
            return this.resultProcessor;
        }

        public void setResultProcessor(DataQueryResultProcessor resultProcessor) {
            this.resultProcessor = resultProcessor;
        }
    }

    public static class DataQueryExecutorError {
        private List<String> recordKeys;
        private int recordId;
        private String attributePath;
        private String errorMessage;

        public DataQueryExecutorError(List<String> recordKeys, int recordId, String attributePath, String errorMessage) {
            this.recordKeys = recordKeys;
            this.recordId = recordId;
            this.attributePath = attributePath;
            this.errorMessage = errorMessage;
        }

        public int getRecordId() {
            return this.recordId;
        }

        public List<String> getRecordKeys() {
            return this.recordKeys;
        }

        public String getAttributePath() {
            return this.attributePath;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

