/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.idm.metamodel.Precision;
import org.openforis.idm.metamodel.Unit;

public class PrecisionFormObject
extends FormObject<Precision> {
    private Unit unit;
    private Integer decimalDigits;
    private boolean defaultPrecision;

    public static List<PrecisionFormObject> fromList(List<Precision> precisionDefinitions, String languageCode) {
        ArrayList<PrecisionFormObject> result = new ArrayList<PrecisionFormObject>();
        for (Precision precision : precisionDefinitions) {
            PrecisionFormObject formObject = new PrecisionFormObject();
            formObject.loadFrom(precision, languageCode);
            result.add(formObject);
        }
        return result;
    }

    @Override
    public void loadFrom(Precision source, String languageCode) {
        this.unit = source.getUnit();
        this.decimalDigits = source.getDecimalDigits();
        this.defaultPrecision = source.isDefaultPrecision();
    }

    @Override
    public void saveTo(Precision dest, String languageCode) {
        dest.setUnit(this.unit);
        dest.setDecimalDigits(this.decimalDigits);
        dest.setDefaultPrecision(this.defaultPrecision);
    }

    @Override
    protected void reset() {
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Integer getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(Integer decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public boolean isDefaultPrecision() {
        return this.defaultPrecision;
    }

    public void setDefaultPrecision(boolean defaultPrecision) {
        this.defaultPrecision = defaultPrecision;
    }
}

