/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.HashMap;
import org.openforis.collect.designer.component.SchemaTreeModel;
import org.openforis.collect.designer.component.SchemaTreeModelCreator;
import org.openforis.collect.designer.component.UITreeModelCreator;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Predicate;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.SurveyObject;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Window;

public class SchemaObjectSelectorPopUpVM
extends SurveyBaseVM {
    public static final String NODE_SELECTED_EVENT_NAME = "onNodeSelected";
    private SchemaTreeModel treeModel;
    private SurveyObject selectedNode;
    private Predicate<SurveyObject> selectableNodePredicate;
    private Predicate<SurveyObject> disabledNodePredicate;
    private boolean allowEmptySelection;
    @WireVariable
    private SurveyManager surveyManager;

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="includeSurveys") boolean includeSurveys, @ExecutionArgParam(value="rootEntity") EntityDefinition rootEntity, @ExecutionArgParam(value="version") ModelVersion version, @ExecutionArgParam(value="includedNodePredicate") Predicate<SurveyObject> includedNodePredicate, @ExecutionArgParam(value="includeRootEntity") boolean includeRootEntity, @ExecutionArgParam(value="includeEmptyNodes") boolean includeEmtptyNodes, @ExecutionArgParam(value="disabledNodePredicate") Predicate<SurveyObject> disabledNodePredicate, @ExecutionArgParam(value="selectableNodePredicate") Predicate<SurveyObject> selectableNodePredicate, @ExecutionArgParam(value="selection") SurveyObject selection, @ExecutionArgParam(value="allowEmptySelection") boolean allowEmptySelection) {
        super.init();
        if (includeSurveys) {
            SchemaTreeModelCreator modelCreator = new SchemaTreeModelCreator(this.surveyManager, this.getLoggedUser(), version, disabledNodePredicate, includedNodePredicate, includeRootEntity, includeEmtptyNodes, this.currentLanguageCode);
            this.treeModel = modelCreator.createModel(true);
        } else {
            UITreeModelCreator modelCreator = new UITreeModelCreator(this.surveyManager, this.getLoggedUser(), version, disabledNodePredicate, includedNodePredicate, includeRootEntity, includeEmtptyNodes, this.currentLanguageCode);
            this.treeModel = modelCreator.createModel(rootEntity);
            this.treeModel.openAllItems();
        }
        this.selectableNodePredicate = selectableNodePredicate;
        this.disabledNodePredicate = disabledNodePredicate;
        this.allowEmptySelection = allowEmptySelection;
        if (selection != null) {
            this.selectedNode = selection;
            this.treeModel.select(selection);
            this.treeModel.showSelectedNode();
        }
    }

    public static Window openPopup(String title, boolean includeSurveys, EntityDefinition rootEntity, ModelVersion version, Predicate<SurveyObject> includedNodePredicate, boolean includeRootEntity, boolean includeEmptyNodes, Predicate<SurveyObject> disabledNodePredicate, Predicate<SurveyObject> selectableNodePredicate, SurveyObject selection, boolean allowEmptySelection) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("includeSurveys", includeSurveys);
        args.put("rootEntity", rootEntity);
        args.put("version", version);
        args.put("title", title);
        args.put("disabledNodePredicate", disabledNodePredicate);
        args.put("includedNodePredicate", includedNodePredicate);
        args.put("selectableNodePredicate", selectableNodePredicate);
        args.put("selection", selection);
        args.put("includeRootEntity", includeRootEntity);
        args.put("includeEmptyNodes", includeEmptyNodes);
        args.put("allowEmptySelection", allowEmptySelection);
        return SchemaObjectSelectorPopUpVM.openPopUp(Resources.Component.SCHEMA_TREE_POPUP.getLocation(), true, args);
    }

    @Command
    public void apply(@BindingParam(value="selectedSurveyObject") SurveyObject selectedSurveyObject, @ContextParam(value=ContextType.VIEW) Component view) {
        if (selectedSurveyObject == null && !this.allowEmptySelection) {
            MessageUtil.showWarning("survey.schema.tree.popup.select_a_node", new Object[0]);
        } else if (selectedSurveyObject == null || (this.disabledNodePredicate == null || !this.disabledNodePredicate.evaluate(selectedSurveyObject)) && (this.selectableNodePredicate == null || this.selectableNodePredicate.evaluate(selectedSurveyObject))) {
            Events.postEvent((Event)new NodeSelectedEvent(view, selectedSurveyObject));
        }
    }

    @Command
    public void nodeSelected(@BindingParam(value="node") SurveyObject surveyObject) {
        if (this.selectableNodePredicate != null && !this.selectableNodePredicate.evaluate(surveyObject)) {
            this.treeModel.select(this.selectedNode);
        } else if (this.selectedNode == surveyObject) {
            this.treeModel.clearSelection();
            this.selectedNode = null;
        } else {
            this.selectedNode = surveyObject;
        }
    }

    public SchemaTreeModel getTreeModel() {
        return this.treeModel;
    }

    public static class NodeSelectedEvent
    extends Event {
        private static final long serialVersionUID = 1L;

        public NodeSelectedEvent(Component target, SurveyObject selectedItem) {
            super(SchemaObjectSelectorPopUpVM.NODE_SELECTED_EVENT_NAME, target, (Object)selectedItem);
        }

        public SurveyObject getSelectedItem() {
            return (SurveyObject)this.getData();
        }
    }
}

