/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.impl.DialectAwareJooqConfiguration;
import org.openforis.collect.persistence.jooq.CollectDSLContext;

public class DbInitializer {
    private static final Logger LOG = LogManager.getLogger(DbInitializer.class);
    private ConnectionProvider connectionProvider;

    public DbInitializer(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void start() {
        DialectAwareJooqConfiguration jooqConf = new DialectAwareJooqConfiguration(this.connectionProvider);
        CollectDSLContext dslContext = new CollectDSLContext((Configuration)jooqConf);
        if (!dslContext.isSchemaLess()) {
            this.createDbSchema();
        }
    }

    private void createDbSchema() {
        Connection conn = null;
        try {
            LOG.info("Acquiring connection...");
            conn = this.connectionProvider.acquire();
            conn.setAutoCommit(false);
            LOG.info("Connection acquired!");
            LOG.info(String.format("Creating schema %s if not exists...", "collect"));
            if (this.createSchemaIfNotExists(conn)) {
                LOG.info(String.format("Schema '%s' created (if not existing already)", "collect"));
            } else {
                LOG.info("Try to create schema without 'IF NOT EXISTS' clause");
                boolean schemaCreated = this.createSchema(conn);
                LOG.info(String.format("Schema '%s' %s", "collect", schemaCreated ? "created" : "already exists"));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (conn != null) {
                this.connectionProvider.release(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean createSchemaIfNotExists(Connection conn) {
        try {
            boolean bl;
            Throwable throwable;
            Statement stmt;
            block17: {
                block18: {
                    stmt = conn.createStatement();
                    throwable = null;
                    stmt.execute(String.format("CREATE SCHEMA IF NOT EXISTS %s", "collect"));
                    bl = true;
                    if (stmt == null) break block17;
                    if (throwable == null) break block18;
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block17;
                }
                stmt.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (stmt != null) {
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    LOG.info("CREATE SCHEMA IF NOT EXISTS is not supported by this DBMS");
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        finally {
            this.commitQuietly(conn);
        }
    }

    /*
     * Loose catch block
     */
    private boolean createSchema(Connection conn) {
        try {
            boolean bl;
            Throwable throwable;
            Statement stmt;
            block19: {
                block20: {
                    stmt = conn.createStatement();
                    throwable = null;
                    stmt.execute(String.format("CREATE SCHEMA %s", "collect"));
                    bl = true;
                    if (stmt == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                stmt.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (stmt != null) {
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    boolean schemaAlreadyExists = e.getMessage().toLowerCase(Locale.ENGLISH).contains(" already ");
                    if (schemaAlreadyExists) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    String errorMessage = String.format("Error creating schema '%s'", "collect");
                    LOG.error(errorMessage, (Throwable)e);
                    throw new RuntimeException(errorMessage, e);
                }
            }
        }
        finally {
            this.commitQuietly(conn);
        }
    }

    private void commitQuietly(Connection conn) {
        try {
            conn.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

