/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import jakarta.validation.Valid;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.collect.utils.SurveyObjects;
import org.openforis.collect.web.controller.AbstractPersistedObjectEditFormController;
import org.openforis.collect.web.validator.UserGroupValidator;
import org.openforis.commons.web.PersistedObjectForm;
import org.openforis.commons.web.Response;
import org.openforis.commons.web.SimpleObjectForm;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/usergroup"})
@Scope(value="session")
public class UserGroupController
extends AbstractPersistedObjectEditFormController<Integer, UserGroup, UserGroupForm, UserGroupManager> {
    private static final String RESOURCE_TYPE_REGEX = "[a-z][a-z0-9_]*";
    @Autowired
    private UserGroupValidator userGroupValidator;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SurveyManager surveyManager;

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        if (binder.getTarget() instanceof UserGroup) {
            binder.setValidator((Validator)this.userGroupValidator);
        }
    }

    @Override
    protected UserGroup createItemInstance() {
        UserGroup userGroup = new UserGroup();
        userGroup.setCreationDate(new Timestamp(System.currentTimeMillis()));
        userGroup.setCreatedByUser(this.sessionManager.getSessionState().getUser());
        return userGroup;
    }

    @Override
    protected UserGroupForm createFormInstance(UserGroup item) {
        return new UserGroupForm(item);
    }

    @Override
    protected List<UserGroup> loadAllItems() {
        User loggedUser = this.sessionManager.getLoggedUser();
        return ((UserGroupManager)this.itemManager).findAllRelatedUserGroups(loggedUser);
    }

    @RequestMapping(value={"/{userGroupId}/resources/{resourceType}/{resourceId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Response associateToResource(@PathVariable int userGroupId, @PathVariable String resourceType, @PathVariable String resourceId) {
        if (StringUtils.isBlank((CharSequence)resourceType) || !resourceType.matches(RESOURCE_TYPE_REGEX)) {
            throw new IllegalArgumentException("Invalid resource type specified");
        }
        String resourceIdNormalized = SurveyObjects.adjustInternalName((String)resourceId);
        ((UserGroupManager)this.itemManager).associateResource(userGroupId, resourceType, resourceIdNormalized);
        return new Response();
    }

    @RequestMapping(value={"/{userGroupId}/resources/{resourceType}/{resourceId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Response disassociateToResource(@PathVariable int userGroupId, @PathVariable String resourceType, @PathVariable String resourceId) {
        ((UserGroupManager)this.itemManager).disassociateResource(userGroupId, resourceType, resourceId);
        return new Response();
    }

    @Override
    @Transactional
    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public Response delete(@Valid UserGroupsDeleteParameters parameters) {
        List surveys = this.surveyManager.loadCombinedSummaries(Locale.getDefault().getLanguage(), false, parameters.getLoggedUserId(), new HashSet<Integer>(parameters.getUserGroupIds()), null);
        if (!surveys.isEmpty()) {
            throw new IllegalArgumentException("Cannot delete user group, there is one survey associated to the specified user groups: " + parameters.getUserGroupIds());
        }
        for (int id : parameters.getUserGroupIds()) {
            ((UserGroupManager)this.itemManager).deleteById((Object)id);
        }
        return new Response();
    }

    public static class UserGroupsDeleteParameters {
        private int loggedUserId;
        private List<Integer> userGroupIds;

        public int getLoggedUserId() {
            return this.loggedUserId;
        }

        public void setLoggedUserId(int loggedUserId) {
            this.loggedUserId = loggedUserId;
        }

        public List<Integer> getUserGroupIds() {
            return this.userGroupIds;
        }

        public void setUserGroupIds(List<Integer> userGroupIds) {
            this.userGroupIds = userGroupIds;
        }
    }

    public static class UserInGroupForm
    extends SimpleObjectForm<UserInGroup> {
        private UserInGroup.UserGroupRole role;
        private Integer groupId;
        private Integer userId;
        private UserInGroup.UserGroupJoinRequestStatus joinStatus;
        private Date joinRequestDate;
        private Date memberSince;

        public UserInGroupForm() {
        }

        public UserInGroupForm(UserInGroup userInGroup) {
            this.groupId = userInGroup.getGroupId();
            this.userId = userInGroup.getUserId();
            this.role = userInGroup.getRole();
            this.joinStatus = userInGroup.getJoinStatus();
            this.joinRequestDate = userInGroup.getRequestDate();
            this.memberSince = userInGroup.getMemberSince();
        }

        public Integer getGroupId() {
            return this.groupId;
        }

        public void setGroupId(Integer groupId) {
            this.groupId = groupId;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public UserInGroup.UserGroupRole getRole() {
            return this.role;
        }

        public void setRole(UserInGroup.UserGroupRole role) {
            this.role = role;
        }

        public UserInGroup.UserGroupJoinRequestStatus getJoinStatus() {
            return this.joinStatus;
        }

        public void setJoinStatus(UserInGroup.UserGroupJoinRequestStatus joinStatus) {
            this.joinStatus = joinStatus;
        }

        public Date getJoinRequestDate() {
            return this.joinRequestDate;
        }

        public Date getMemberSince() {
            return this.memberSince;
        }
    }

    public static class UserGroupForm
    extends PersistedObjectForm<Integer, UserGroup> {
        private String name;
        private String label;
        private String description;
        private String visibilityCode;
        private Integer parentId;
        private Boolean enabled;
        private String qualifierName;
        private String qualifierValue;
        private boolean systemDefined;
        private List<UserInGroupForm> users = new ArrayList<UserInGroupForm>();
        private List<Integer> childrenGroupIds = new ArrayList<Integer>();

        public UserGroupForm() {
        }

        public UserGroupForm(UserGroup userGroup) {
            BeanUtils.copyProperties((Object)userGroup, (Object)((Object)this), (String[])new String[]{"users"});
            this.users.clear();
            for (UserInGroup user : userGroup.getUsers()) {
                this.users.add(new UserInGroupForm(user));
            }
            this.childrenGroupIds = new ArrayList<Integer>(userGroup.getChildrenGroupIds());
        }

        public void copyTo(UserGroup target, String ... ignoreProperties) {
            super.copyTo((Object)target, (String[])ArrayUtils.addAll((Object[])ignoreProperties, (Object[])new String[]{"users"}));
            HashSet<UserInGroup> users = new HashSet<UserInGroup>();
            for (UserInGroupForm userInGroupForm : this.users) {
                UserInGroup userInGroup = new UserInGroup();
                userInGroup.setGroupId(target.getId());
                userInGroup.setUserId(userInGroupForm.getUserId());
                userInGroup.setRole(userInGroupForm.getRole());
                userInGroup.setJoinStatus(userInGroupForm.getJoinStatus());
                users.add(userInGroup);
            }
            target.setUsers(users);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVisibilityCode() {
            return this.visibilityCode;
        }

        public void setVisibilityCode(String visibilityCode) {
            this.visibilityCode = visibilityCode;
        }

        public Integer getParentId() {
            return this.parentId;
        }

        public void setParentId(Integer parentId) {
            this.parentId = parentId;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getQualifierName() {
            return this.qualifierName;
        }

        public void setQualifierName(String qualifierName) {
            this.qualifierName = qualifierName;
        }

        public String getQualifierValue() {
            return this.qualifierValue;
        }

        public void setQualifierValue(String qualifierValue) {
            this.qualifierValue = qualifierValue;
        }

        public boolean isSystemDefined() {
            return this.systemDefined;
        }

        public void setSystemDefined(boolean systemDefined) {
            this.systemDefined = systemDefined;
        }

        public List<UserInGroupForm> getUsers() {
            return this.users;
        }

        public void setUsers(List<UserInGroupForm> users) {
            this.users = users;
        }

        public List<Integer> getChildrenGroupIds() {
            return this.childrenGroupIds;
        }

        public void setChildrenGroupIds(List<Integer> childrenGroupIds) {
            this.childrenGroupIds = childrenGroupIds;
        }
    }
}

