/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form.validation;

import org.openforis.collect.datacleansing.DataQueryType;
import org.openforis.collect.datacleansing.form.DataQueryTypeForm;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.datacleansing.manager.DataQueryTypeManager;
import org.openforis.collect.model.CollectSurvey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class DataQueryTypeValidator
extends SimpleValidator<DataQueryTypeForm> {
    private static final String CODE_FIELD = "code";
    @Autowired
    private DataQueryTypeManager dataQueryTypeManager;

    @Override
    public void validateForm(DataQueryTypeForm target, Errors errors) {
        if (this.validateRequiredField(errors, CODE_FIELD)) {
            this.validateCodeUniqueness(target, errors);
        }
    }

    private boolean validateCodeUniqueness(DataQueryTypeForm target, Errors errors) {
        CollectSurvey survey = this.getActiveSurvey();
        DataQueryType existingItem = this.dataQueryTypeManager.loadByCode(survey, target.getCode());
        if (existingItem != null && !((Integer)existingItem.getId()).equals(target.getId())) {
            this.rejectDuplicateValue(errors, CODE_FIELD, new Object[0]);
            return false;
        }
        return true;
    }
}

