/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingMetadata;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.DataQueryType;
import org.openforis.collect.datacleansing.manager.DataCleansingChainManager;
import org.openforis.collect.datacleansing.manager.DataCleansingMetadataManager;
import org.openforis.collect.datacleansing.manager.DataCleansingReportManager;
import org.openforis.collect.datacleansing.manager.DataCleansingStepManager;
import org.openforis.collect.datacleansing.manager.DataQueryGroupManager;
import org.openforis.collect.datacleansing.manager.DataQueryManager;
import org.openforis.collect.datacleansing.manager.DataQueryTypeManager;
import org.openforis.collect.datacleansing.manager.DataReportManager;
import org.openforis.collect.manager.AbstractSurveyObjectManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.openforis.idm.metamodel.Survey;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataCleansingManager")
@Transactional
public class DataCleansingManagerImpl
implements DataCleansingMetadataManager {
    private static final String ID_PROPERTY_NAME = "id";
    private static final String UUID_PROPERTY_NAME = "uuid";
    @Autowired
    private DataQueryManager dataQueryManager;
    @Autowired
    private DataQueryGroupManager dataQueryGroupManager;
    @Autowired
    private DataQueryTypeManager dataTypeManager;
    @Autowired
    private DataCleansingStepManager dataCleansingStepManager;
    @Autowired
    private DataCleansingChainManager dataCleansingChainManager;
    @Autowired
    private DataCleansingReportManager dataCleansingReportManager;
    @Autowired
    private DataReportManager dataReportManager;

    @Override
    public DataCleansingMetadata loadMetadata(CollectSurvey survey) {
        List dataQueries = this.dataQueryManager.loadBySurvey(survey);
        List dataQueryTypes = this.dataTypeManager.loadBySurvey(survey);
        Iterator iterator = dataQueries.iterator();
        while (iterator.hasNext()) {
            Object dataQuery;
            Integer typeId = ((DataQuery)((Object)(dataQuery = (DataQuery)((Object)iterator.next())))).getTypeId();
            ((DataQuery)((Object)dataQuery)).setType(typeId == null ? null : (DataQueryType)((Object)CollectionUtils.findItem((Collection)dataQueryTypes, (Object)typeId)));
        }
        List dataQueryGroups = this.dataQueryGroupManager.loadBySurvey(survey);
        for (Object group : dataQueryGroups) {
            List<DataQuery> queries = ((DataQueryGroup)((Object)group)).getQueries();
            ArrayList<DataQuery> correctQueries = new ArrayList<DataQuery>(queries.size());
            for (DataQuery dataQuery : queries) {
                correctQueries.add((DataQuery)((Object)CollectionUtils.findItem((Collection)dataQueries, (Object)dataQuery.getId())));
            }
            ((DataQueryGroup)((Object)group)).removeAllQueries();
            ((DataQueryGroup)((Object)group)).allAllQueries(correctQueries);
        }
        List cleansingSteps = this.dataCleansingStepManager.loadBySurvey(survey);
        for (Object step : cleansingSteps) {
            ((DataCleansingStep)((Object)step)).setQuery((DataQuery)((Object)CollectionUtils.findItem((Collection)dataQueries, (Object)((DataCleansingStep)((Object)step)).getQueryId())));
        }
        List cleansingChains = this.dataCleansingChainManager.loadBySurvey(survey);
        for (DataCleansingChain chain : cleansingChains) {
            List<DataCleansingStep> steps = chain.getSteps();
            ArrayList<DataCleansingStep> correctSteps = new ArrayList<DataCleansingStep>(steps.size());
            for (DataCleansingStep step : steps) {
                correctSteps.add((DataCleansingStep)((Object)CollectionUtils.findItem((Collection)cleansingSteps, (Object)step.getId())));
            }
            chain.removeAllSteps();
            chain.addAllSteps(correctSteps);
        }
        DataCleansingMetadata metadata = new DataCleansingMetadata(survey, dataQueryTypes, dataQueries, dataQueryGroups, cleansingSteps, cleansingChains);
        return metadata;
    }

    @Override
    @Transactional
    public void saveMetadata(CollectSurvey survey, DataCleansingMetadata metadata, boolean skipErrors, User activeUser) {
        this.saveItems(this.dataTypeManager, survey, metadata.getDataQueryTypes(), skipErrors, activeUser);
        this.saveItems(this.dataQueryManager, survey, metadata.getDataQueries(), skipErrors, activeUser);
        this.saveItems(this.dataQueryGroupManager, survey, metadata.getDataQueryGroups(), skipErrors, activeUser);
        this.saveItems(this.dataCleansingStepManager, survey, metadata.getCleansingSteps(), skipErrors, activeUser);
        this.saveItems(this.dataCleansingChainManager, survey, metadata.getCleansingChains(), skipErrors, activeUser);
    }

    @Transactional
    public void moveMetadata(CollectSurvey fromSurvey, CollectSurvey toSurvey, User activeUser) {
        DataCleansingMetadata temporaryMetadata = this.loadMetadata(fromSurvey);
        this.saveMetadata(toSurvey, temporaryMetadata, false, activeUser);
        this.deleteMetadata(fromSurvey);
    }

    @Transactional
    public void deleteMetadata(CollectSurvey survey) {
        List<AbstractSurveyObjectManager> managers = Arrays.asList(new AbstractSurveyObjectManager[]{this.dataCleansingReportManager, this.dataCleansingChainManager, this.dataCleansingStepManager, this.dataReportManager, this.dataQueryGroupManager, this.dataQueryManager, this.dataTypeManager});
        for (AbstractSurveyObjectManager manager : managers) {
            manager.deleteBySurvey(survey);
        }
    }

    @Transactional
    public void duplicateMetadata(CollectSurvey fromSurvey, CollectSurvey toSurvey, User activeUser) {
        DataCleansingMetadata metadata = this.loadMetadata(fromSurvey);
        this.saveMetadata(toSurvey, metadata, false, activeUser);
    }

    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public boolean isNodeDefinitionInUse(NodeDefinition nodeDef) {
        List dataQueries = this.dataQueryManager.loadBySurvey((CollectSurvey)nodeDef.getSurvey());
        for (DataQuery dataQuery : dataQueries) {
            if (dataQuery.getAttributeDefinitionId() != nodeDef.getId()) continue;
            return true;
        }
        return false;
    }

    private <T extends PersistedSurveyObject<Integer>> void saveItems(AbstractSurveyObjectManager<Integer, T, ?> manager, CollectSurvey survey, List<T> items, boolean skipErrors, User activeUser) {
        List oldItems = manager.loadBySurvey(survey);
        for (PersistedSurveyObject item : items) {
            PersistedSurveyObject oldItem;
            block5: {
                item.replaceSurvey((Survey)survey);
                oldItem = (PersistedSurveyObject)CollectionUtils.findItem((Collection)oldItems, (Object)item.getUuid(), (String)UUID_PROPERTY_NAME);
                if (oldItem == null) {
                    item.setId(null);
                    manager.save(item, activeUser);
                    continue;
                }
                try {
                    BeanUtils.copyProperties((Object)item, (Object)oldItem, (String[])new String[]{ID_PROPERTY_NAME, UUID_PROPERTY_NAME});
                }
                catch (Exception e) {
                    if (skipErrors) break block5;
                    throw new RuntimeException("Error saving data cleansing items", e);
                }
            }
            manager.save(oldItem, activeUser);
            item.setId((Number)((Integer)oldItem.getId()));
        }
        for (PersistedSurveyObject oldItem : oldItems) {
            PersistedSurveyObject newItem = (PersistedSurveyObject)CollectionUtils.findItem(items, (Object)oldItem.getUuid(), (String)UUID_PROPERTY_NAME);
            if (newItem != null) continue;
            manager.delete(oldItem);
        }
    }
}

