/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.designer.form.NodeDefinitionFormObject;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefault;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.validation.Check;

public class AttributeDefinitionFormObject<T extends AttributeDefinition>
extends NodeDefinitionFormObject<T> {
    public static final String ATTRIBUTE_DEFAULTS_FIELD = "attributeDefaults";
    public static final String CHECKS_FIELD = "checks";
    public static final String KEY_FIELD = "key";
    public static final String MEASUREMENT_FIELD = "measurement";
    public static final String CALCULATED_FIELD = "calculated";
    public static final String REFERENCED_ATTRIBUTE_PATH_FIELD = "referencedAttributePath";
    private List<AttributeDefault> attributeDefaults;
    private String phaseToApplyDefaultValue;
    private String referencedAttributePath;
    private boolean editable;
    private List<Check<?>> checks;
    private String[] visibleFields;
    private boolean showInMapBalloon;

    AttributeDefinitionFormObject(EntityDefinition parentDefn) {
        super(parentDefn);
    }

    @Override
    public void saveTo(T dest, String languageCode) {
        super.saveTo(dest, languageCode);
        dest.setKey(this.key);
        dest.removeAllAttributeDefaults();
        if (this.attributeDefaults != null) {
            for (AttributeDefault attrDefault : this.attributeDefaults) {
                dest.addAttributeDefault(attrDefault);
            }
        }
        dest.setReferencedAttribute(this.referencedAttributePath == null ? null : (AttributeDefinition)dest.getSchema().getDefinitionByPath(this.referencedAttributePath));
        CollectSurvey survey = (CollectSurvey)dest.getSurvey();
        CollectAnnotations annotations = survey.getAnnotations();
        annotations.setPhaseToApplyDefaultValue(dest, CollectRecord.Step.valueOf((String)this.phaseToApplyDefaultValue));
        annotations.setEditable(dest, this.editable);
        annotations.setMeasurementAttribute(dest, this.measurement);
        annotations.setShowInMapBalloon(dest, this.showInMapBalloon);
        dest.removeAllChecks();
        if (this.checks != null) {
            for (Check<?> check : this.checks) {
                dest.addCheck(check);
            }
        }
        UIOptions uiOptions = this.getUIOptions((NodeDefinition)dest);
        uiOptions.setVisibleFields(dest, this.visibleFields);
    }

    @Override
    public void loadFrom(T source, String languageCode) {
        super.loadFrom(source, languageCode);
        this.key = source.isKey();
        this.attributeDefaults = new ArrayList<AttributeDefault>(source.getAttributeDefaults());
        CollectSurvey survey = (CollectSurvey)source.getSurvey();
        CollectAnnotations annotations = survey.getAnnotations();
        this.phaseToApplyDefaultValue = annotations.getPhaseToApplyDefaultValue(source).name();
        this.editable = annotations.isEditable(source);
        this.measurement = annotations.isMeasurementAttribute(source);
        this.showInMapBalloon = annotations.isShowInMapBalloon(source);
        this.checks = new ArrayList(source.getChecks());
        UIOptions uiOptions = this.getUIOptions((NodeDefinition)source);
        this.visibleFields = uiOptions.getVisibleFields(source);
        if (source.getReferencedAttribute() != null) {
            this.referencedAttributePath = source.getReferencedAttribute().getPath();
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.attributeDefaults = new ArrayList<AttributeDefault>();
        this.phaseToApplyDefaultValue = ((CollectRecord.Step)CollectAnnotations.Annotation.PHASE_TO_APPLY_DEFAULT_VALUE.getDefaultValue()).name();
        this.checks = null;
    }

    public List<AttributeDefault> getAttributeDefaults() {
        return this.attributeDefaults;
    }

    public void setAttributeDefaults(List<AttributeDefault> attributeDefaults) {
        this.attributeDefaults = attributeDefaults;
    }

    public String getPhaseToApplyDefaultValue() {
        return this.phaseToApplyDefaultValue;
    }

    public void setPhaseToApplyDefaultValue(String phaseToApplyDefaultValue) {
        this.phaseToApplyDefaultValue = phaseToApplyDefaultValue;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isShowInMapBalloon() {
        return this.showInMapBalloon;
    }

    public void setShowInMapBalloon(boolean showInMapBalloon) {
        this.showInMapBalloon = showInMapBalloon;
    }

    public List<Check<?>> getChecks() {
        return this.checks;
    }

    public void setChecks(List<Check<?>> checks) {
        this.checks = checks;
    }

    public String[] getVisibleFields() {
        return this.visibleFields;
    }

    public void setVisibleFields(String[] visibleFields) {
        this.visibleFields = visibleFields;
    }

    public String getReferencedAttributePath() {
        return this.referencedAttributePath;
    }

    public void setReferencedAttributePath(String referencedAttributePath) {
        this.referencedAttributePath = referencedAttributePath;
    }
}

