/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.PopUpUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.SurveyObject;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Window;

public class SurveyErrorsPopUpVM {
    private static final String ON_CLICK_EVENT = "onClick";
    private static final String OK_BUTTON_ID = "okBtn";
    private static final String CANCEL_BUTTON_ID = "cancelBtn";
    private String title;
    private String message;
    private List<SurveyObjectError> schemaErrors;

    public static Window openPopUp(String title, String message, List<? extends SurveyObject> nodesWithErrors, MessageUtil.ConfirmHandler confirmHandler) {
        return SurveyErrorsPopUpVM.openPopUp(title, message, nodesWithErrors, confirmHandler, false);
    }

    public static Window openPopUp(String title, String message, List<? extends SurveyObject> nodesWithErrors, MessageUtil.ConfirmHandler confirmHandler, boolean hideCancelButton) {
        List<SurveyObjectError> errors = SurveyErrorsPopUpVM.createErrors(nodesWithErrors);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("title", title);
        args.put("message", message);
        args.put("errors", errors);
        args.put("hideCancelButton", hideCancelButton);
        Window result = PopUpUtil.openPopUp(Resources.Component.CONFIRM_SURVEY_ERRORS_POPUP.getLocation(), true, args);
        SurveyErrorsPopUpVM.initEventListeners(result, confirmHandler);
        return result;
    }

    protected static void initEventListeners(Window popUp, final MessageUtil.ConfirmHandler confirmHandler) {
        IdSpace idSpace = popUp.getSpaceOwner();
        Component okButton = Path.getComponent((IdSpace)idSpace, (String)OK_BUTTON_ID);
        okButton.addEventListener(ON_CLICK_EVENT, (EventListener)new EventListener<Event>(){

            public void onEvent(Event arg0) throws Exception {
                confirmHandler.onOk();
            }
        });
        Component cancelButton = Path.getComponent((IdSpace)idSpace, (String)CANCEL_BUTTON_ID);
        cancelButton.addEventListener(ON_CLICK_EVENT, (EventListener)new EventListener<Event>(){

            public void onEvent(Event arg0) throws Exception {
                if (confirmHandler instanceof MessageUtil.CompleteConfirmHandler) {
                    ((MessageUtil.CompleteConfirmHandler)confirmHandler).onCancel();
                }
            }
        });
    }

    protected static List<SurveyObjectError> createErrors(List<? extends SurveyObject> items) {
        ArrayList<SurveyObjectError> errors = new ArrayList<SurveyObjectError>();
        for (SurveyObject surveyObject : items) {
            String path = null;
            String message = null;
            if (surveyObject instanceof NodeDefinition) {
                path = ((NodeDefinition)surveyObject).getPath();
            } else if (surveyObject instanceof CodeList) {
                path = ((CodeList)surveyObject).getName();
            } else if (surveyObject instanceof CodeListItem) {
                CodeListItem codeListItem = (CodeListItem)surveyObject;
                path = SurveyErrorsPopUpVM.getPath(codeListItem);
            }
            SurveyObjectError error = new SurveyObjectError(path, message);
            errors.add(error);
        }
        return errors;
    }

    protected static String getPath(CodeListItem codeListItem) {
        CodeList codeList = codeListItem.getCodeList();
        StringBuilder sb = new StringBuilder();
        for (CodeListItem currentItem = codeListItem; currentItem != null; currentItem = currentItem.getParentItem()) {
            sb.insert(0, currentItem.getCode());
            sb.insert(0, "/");
        }
        sb.insert(0, codeList.getName());
        return sb.toString();
    }

    @Init
    public void init(@ExecutionArgParam(value="title") String title, @ExecutionArgParam(value="message") String message, @ExecutionArgParam(value="errors") List<SurveyObjectError> errors) {
        this.title = title;
        this.message = message;
        this.schemaErrors = errors;
    }

    public List<SurveyObjectError> getSchemaErrors() {
        return new ListModelList(this.schemaErrors);
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public static class SurveyObjectError {
        private String path;
        private String message;

        public SurveyObjectError(String path, String message) {
            this.path = path;
            this.message = message;
        }

        public String getPath() {
            return this.path;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

