/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.util.Iterator;
import java.util.List;
import org.openforis.collect.datacleansing.DataQueryEvaluator;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.model.Node;

public class DataQueryResultIterator
implements Iterator<Node<?>> {
    private DataQueryEvaluator queryEvaluator;
    private RecordManager recordManager;
    private List<CollectRecord> recordSummaries;
    private int currentRecordIndex = 0;
    private CollectRecord currentRecord;
    private List<Node<?>> currentNodes;
    private int currentNodeIndex = 0;
    private boolean active = true;

    public DataQueryResultIterator(RecordManager recordManager, List<CollectRecord> recordSummaries, DataQueryEvaluator queryEvaluator) {
        this.recordManager = recordManager;
        this.recordSummaries = recordSummaries;
        this.queryEvaluator = queryEvaluator;
    }

    @Override
    public boolean hasNext() {
        this.checkActive();
        if (this.currentRecordIndex > this.recordSummaries.size()) {
            return false;
        }
        if (this.currentRecord == null || this.currentNodeIndex >= this.currentNodes.size()) {
            this.fetchNextRecord();
        }
        return this.currentRecord != null;
    }

    private void checkActive() {
        if (!this.active) {
            throw new IllegalStateException("The query result iterator has been deactivated.");
        }
    }

    @Override
    public Node<?> next() {
        if (this.hasNext()) {
            return this.currentNodes.get(this.currentNodeIndex++);
        }
        return null;
    }

    private void fetchNextRecord() {
        this.currentRecord = null;
        this.currentNodes = null;
        this.currentNodeIndex = 0;
        while (this.active && this.currentRecordIndex < this.recordSummaries.size()) {
            CollectRecord summary;
            CollectRecord record;
            List<Node<?>> nodes;
            if ((nodes = this.queryEvaluator.evaluate(record = this.recordManager.load((CollectSurvey)(summary = this.recordSummaries.get(this.currentRecordIndex++)).getSurvey(), summary.getId().intValue()))).isEmpty()) continue;
            this.currentRecord = record;
            this.currentNodes = nodes;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void deactivate() {
        this.setActive(false);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

