/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form.validation;

import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.DataCleansingStepValue;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.form.DataCleansingStepForm;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.datacleansing.manager.DataCleansingStepManager;
import org.openforis.collect.datacleansing.manager.DataQueryManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.collection.CollectionUtils;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class DataCleansingStepValidator
extends SimpleValidator<DataCleansingStepForm> {
    private static final String UPDATE_VALUES_FIELD = "updateValues";
    private static final String TITLE_FIELD = "title";
    private static final String QUERY_ID_FIELD = "queryId";
    private static final String TYPE_CODE_FIELD = "typeCode";
    @Autowired
    private DataQueryManager dataQueryManager;
    @Autowired
    private DataCleansingStepManager dataCleansingStepManager;

    @Override
    public void validateForm(DataCleansingStepForm target, Errors errors) {
        String typeCode;
        if (this.validateRequiredFields(errors, TITLE_FIELD, QUERY_ID_FIELD, TYPE_CODE_FIELD) && this.validateUniqueness(target, errors) && (typeCode = (String)errors.getFieldValue(TYPE_CODE_FIELD)).length() == 1 && typeCode.charAt(0) == DataCleansingStep.DataCleansingStepType.ATTRIBUTE_UPDATE.getCode()) {
            this.validateUpdateValues(target, errors);
        }
    }

    private void validateUpdateValues(DataCleansingStepForm target, Errors errors) {
        CollectSurvey survey = this.getActiveSurvey();
        DataQuery query = (DataQuery)this.dataQueryManager.loadById(survey, target.getQueryId());
        AttributeDefinition attrDef = query.getAttributeDefinition();
        List<DataCleansingStepValue> updateValues = target.getUpdateValues();
        int updateValueIndex = 0;
        for (DataCleansingStepValue updateValue : updateValues) {
            this.validateCondition(target, errors, updateValue, updateValueIndex == updateValues.size() - 1);
            switch (updateValue.getUpdateType()) {
                case ATTRIBUTE: {
                    this.validateUpdateByAttribute(errors, updateValue, attrDef, updateValueIndex);
                    break;
                }
                case FIELD: {
                    this.validateUpdateByField(errors, attrDef, updateValueIndex, updateValue);
                }
            }
            ++updateValueIndex;
        }
    }

    private void validateUpdateByField(Errors errors, AttributeDefinition attrDef, int fixIndex, DataCleansingStepValue updateValue) {
        List<String> fieldFixExpressions;
        String errorCode;
        if (StringUtils.isNotBlank((CharSequence)updateValue.getFixExpression())) {
            Object[] args = new Object[]{fixIndex + 1};
            errorCode = "data_cleansing_step.validation.cannot_specify_field_update_expressions";
            errors.rejectValue(UPDATE_VALUES_FIELD, errorCode, args, this.messageSource.getMessage(errorCode, args, Locale.ENGLISH));
        }
        if (this.isEmpty(fieldFixExpressions = updateValue.getFieldFixExpressions())) {
            errorCode = "data_cleansing_step.validation.required_fix_expression";
            Object[] args = new Object[]{fixIndex + 1};
            errors.rejectValue(UPDATE_VALUES_FIELD, errorCode, args, this.messageSource.getMessage(errorCode, args, Locale.ENGLISH));
        } else {
            for (String expr : fieldFixExpressions) {
                if (!StringUtils.isNotBlank((CharSequence)expr)) continue;
                this.validateValueExpression(errors, (NodeDefinition)attrDef.getParentEntityDefinition(), (NodeDefinition)attrDef, UPDATE_VALUES_FIELD, expr);
            }
        }
    }

    private void validateUpdateByAttribute(Errors errors, DataCleansingStepValue updateValue, AttributeDefinition attrDef, int rowIndex) {
        String fixExpression;
        String errorCode;
        List<String> values = updateValue.getFieldFixExpressions();
        if (!this.isEmpty(values)) {
            Object[] args = new Object[]{rowIndex + 1};
            errorCode = "data_cleansing_step.validation.cannot_specify_field_update_expressions";
            String defaultMessage = this.messageSource.getMessage(errorCode, args, Locale.ENGLISH);
            errors.rejectValue(UPDATE_VALUES_FIELD, errorCode, args, defaultMessage);
        }
        if (StringUtils.isBlank((CharSequence)(fixExpression = updateValue.getFixExpression()))) {
            errorCode = "data_cleansing_step.validation.required_fix_expression";
            Object[] args = new Object[]{rowIndex + 1};
            String defaultMessage = this.messageSource.getMessage(errorCode, args, Locale.ENGLISH);
            errors.rejectValue(UPDATE_VALUES_FIELD, errorCode, args, defaultMessage);
        } else {
            this.validateValueExpression(errors, (NodeDefinition)attrDef.getParentEntityDefinition(), (NodeDefinition)attrDef, UPDATE_VALUES_FIELD, fixExpression);
        }
    }

    private void validateCondition(DataCleansingStepForm target, Errors errors, DataCleansingStepValue updateValue, boolean lastRow) {
        String condition = updateValue.getCondition();
        if (StringUtils.isBlank((CharSequence)condition)) {
            return;
        }
        CollectSurvey survey = this.getActiveSurvey();
        DataQuery query = (DataQuery)this.dataQueryManager.loadById(survey, target.getQueryId());
        AttributeDefinition attrDef = query.getAttributeDefinition();
        this.validateBooleanExpression(errors, (NodeDefinition)attrDef.getParentEntityDefinition(), (NodeDefinition)attrDef, UPDATE_VALUES_FIELD, condition);
    }

    private boolean isEmpty(List<String> values) {
        if (values == null) {
            return true;
        }
        for (String value : values) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return false;
        }
        return true;
    }

    private boolean validateUniqueness(DataCleansingStepForm target, Errors errors) {
        CollectSurvey survey = this.getActiveSurvey();
        List steps = this.dataCleansingStepManager.loadBySurvey(survey);
        for (DataCleansingStep step : steps) {
            if (((Integer)step.getId()).equals(target.getId()) || !step.getQueryId().equals(target.getQueryId()) || !CollectionUtils.deepEquals(step.getUpdateValues(), target.getUpdateValues())) continue;
            this.rejectDuplicateValue(errors, QUERY_ID_FIELD, new Object[0]);
            return false;
        }
        return true;
    }
}

